/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTMultiDrawIndirect {
    protected EXTMultiDrawIndirect() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glMultiDrawArraysIndirectEXT, caps.glMultiDrawElementsIndirectEXT);
    }

    public static void nglMultiDrawArraysIndirectEXT(int mode, long indirect, int drawcount, int stride) {
        long __functionAddress = GLES.getCapabilities().glMultiDrawArraysIndirectEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, indirect, drawcount, stride);
    }

    public static void glMultiDrawArraysIndirectEXT(int mode, ByteBuffer indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, drawcount * (stride == 0 ? 16 : stride));
            GLESChecks.ensureBufferObject(36675, false);
        }
        EXTMultiDrawIndirect.nglMultiDrawArraysIndirectEXT(mode, MemoryUtil.memAddress(indirect), drawcount, stride);
    }

    public static void glMultiDrawArraysIndirectEXT(int mode, long indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(36675, true);
        }
        EXTMultiDrawIndirect.nglMultiDrawArraysIndirectEXT(mode, indirect, drawcount, stride);
    }

    public static void glMultiDrawArraysIndirectEXT(int mode, IntBuffer indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, drawcount * (stride == 0 ? 16 : stride) >> 2);
            GLESChecks.ensureBufferObject(36675, false);
        }
        EXTMultiDrawIndirect.nglMultiDrawArraysIndirectEXT(mode, MemoryUtil.memAddress(indirect), drawcount, stride);
    }

    public static void nglMultiDrawElementsIndirectEXT(int mode, int type, long indirect, int drawcount, int stride) {
        long __functionAddress = GLES.getCapabilities().glMultiDrawElementsIndirectEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, type, indirect, drawcount, stride);
    }

    public static void glMultiDrawElementsIndirectEXT(int mode, int type, ByteBuffer indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, drawcount * (stride == 0 ? 20 : stride));
            GLESChecks.ensureBufferObject(36675, false);
        }
        EXTMultiDrawIndirect.nglMultiDrawElementsIndirectEXT(mode, type, MemoryUtil.memAddress(indirect), drawcount, stride);
    }

    public static void glMultiDrawElementsIndirectEXT(int mode, int type, long indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(36675, true);
        }
        EXTMultiDrawIndirect.nglMultiDrawElementsIndirectEXT(mode, type, indirect, drawcount, stride);
    }

    public static void glMultiDrawElementsIndirectEXT(int mode, int type, IntBuffer indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, drawcount * (stride == 0 ? 20 : stride) >> 2);
            GLESChecks.ensureBufferObject(36675, false);
        }
        EXTMultiDrawIndirect.nglMultiDrawElementsIndirectEXT(mode, type, MemoryUtil.memAddress(indirect), drawcount, stride);
    }

    public static void glMultiDrawArraysIndirectEXT(int mode, int[] indirect, int drawcount, int stride) {
        long __functionAddress = GLES.getCapabilities().glMultiDrawArraysIndirectEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indirect, drawcount * (stride == 0 ? 16 : stride));
            GLESChecks.ensureBufferObject(36675, false);
        }
        JNI.callPV(__functionAddress, mode, indirect, drawcount, stride);
    }

    public static void glMultiDrawElementsIndirectEXT(int mode, int type, int[] indirect, int drawcount, int stride) {
        long __functionAddress = GLES.getCapabilities().glMultiDrawElementsIndirectEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indirect, drawcount * (stride == 0 ? 20 : stride));
            GLESChecks.ensureBufferObject(36675, false);
        }
        JNI.callPV(__functionAddress, mode, type, indirect, drawcount, stride);
    }
}

