/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTMultiDrawArrays {
    protected EXTMultiDrawArrays() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glMultiDrawArraysEXT, caps.glMultiDrawElementsEXT);
    }

    public static void nglMultiDrawArraysEXT(int mode, long first, long count, int primcount) {
        long __functionAddress = GLES.getCapabilities().glMultiDrawArraysEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, mode, first, count, primcount);
    }

    public static void glMultiDrawArraysEXT(int mode, IntBuffer first, IntBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, first.remaining());
        }
        EXTMultiDrawArrays.nglMultiDrawArraysEXT(mode, MemoryUtil.memAddress(first), MemoryUtil.memAddress(count), first.remaining());
    }

    public static void nglMultiDrawElementsEXT(int mode, long count, int type, long indices, int primcount) {
        long __functionAddress = GLES.getCapabilities().glMultiDrawElementsEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glMultiDrawElementsEXT(int mode, IntBuffer count, int type, PointerBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(indices, count.remaining());
        }
        EXTMultiDrawArrays.nglMultiDrawElementsEXT(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), count.remaining());
    }

    public static void glMultiDrawArraysEXT(int mode, int[] first, int[] count) {
        long __functionAddress = GLES.getCapabilities().glMultiDrawArraysEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(count, first.length);
        }
        JNI.callPPV(__functionAddress, mode, first, count, first.length);
    }

    public static void glMultiDrawElementsEXT(int mode, int[] count, int type, PointerBuffer indices) {
        long __functionAddress = GLES.getCapabilities().glMultiDrawElementsEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indices, count.length);
        }
        JNI.callPPV(__functionAddress, mode, count, type, MemoryUtil.memAddress(indices), count.length);
    }
}

