/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVShaderBufferLoad {
    public static final int GL_BUFFER_GPU_ADDRESS_NV = 36637;
    public static final int GL_GPU_ADDRESS_NV = 36660;
    public static final int GL_MAX_SHADER_BUFFER_ADDRESS_NV = 36661;

    protected NVShaderBufferLoad() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glMakeBufferResidentNV, caps.glMakeBufferNonResidentNV, caps.glIsBufferResidentNV, caps.glMakeNamedBufferResidentNV, caps.glMakeNamedBufferNonResidentNV, caps.glIsNamedBufferResidentNV, caps.glGetBufferParameterui64vNV, caps.glGetNamedBufferParameterui64vNV, caps.glGetIntegerui64vNV, caps.glUniformui64NV, caps.glUniformui64vNV, caps.glGetUniformui64vNV, caps.glProgramUniformui64NV, caps.glProgramUniformui64vNV);
    }

    public static void glMakeBufferResidentNV(int target, int access) {
        long __functionAddress = GL.getCapabilities().glMakeBufferResidentNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, access);
    }

    public static void glMakeBufferNonResidentNV(int target) {
        long __functionAddress = GL.getCapabilities().glMakeBufferNonResidentNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target);
    }

    public static boolean glIsBufferResidentNV(int target) {
        long __functionAddress = GL.getCapabilities().glIsBufferResidentNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, target);
    }

    public static void glMakeNamedBufferResidentNV(int buffer, int access) {
        long __functionAddress = GL.getCapabilities().glMakeNamedBufferResidentNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, buffer, access);
    }

    public static void glMakeNamedBufferNonResidentNV(int buffer) {
        long __functionAddress = GL.getCapabilities().glMakeNamedBufferNonResidentNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, buffer);
    }

    public static boolean glIsNamedBufferResidentNV(int buffer) {
        long __functionAddress = GL.getCapabilities().glIsNamedBufferResidentNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, buffer);
    }

    public static void nglGetBufferParameterui64vNV(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetBufferParameterui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetBufferParameterui64vNV(int target, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetBufferParameterui64NV(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetNamedBufferParameterui64vNV(int buffer, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetNamedBufferParameterui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, buffer, pname, params);
    }

    public static void glGetNamedBufferParameterui64vNV(int buffer, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetNamedBufferParameterui64NV(int buffer, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetIntegerui64vNV(int value, long result) {
        long __functionAddress = GL.getCapabilities().glGetIntegerui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, value, result);
    }

    public static void glGetIntegerui64vNV(int value, LongBuffer result) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)result, 1);
        }
        NVShaderBufferLoad.nglGetIntegerui64vNV(value, MemoryUtil.memAddress(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetIntegerui64NV(int value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer result = stack.callocLong(1);
            NVShaderBufferLoad.nglGetIntegerui64vNV(value, MemoryUtil.memAddress(result));
            long l = result.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glUniformui64NV(int location, long value) {
        long __functionAddress = GL.getCapabilities().glUniformui64NV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callJV(__functionAddress, location, value);
    }

    public static void nglUniformui64vNV(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniformui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniformui64vNV(int location, LongBuffer value) {
        NVShaderBufferLoad.nglUniformui64vNV(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglGetUniformui64vNV(int program, int location, long params) {
        long __functionAddress = GL.getCapabilities().glGetUniformui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformui64vNV(int program, int location, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        NVShaderBufferLoad.nglGetUniformui64vNV(program, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetUniformui64NV(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            NVShaderBufferLoad.nglGetUniformui64vNV(program, location, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glProgramUniformui64NV(int program, int location, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformui64NV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callJV(__functionAddress, program, location, value);
    }

    public static void nglProgramUniformui64vNV(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniformui64vNV(int program, int location, LongBuffer value) {
        NVShaderBufferLoad.nglProgramUniformui64vNV(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void glGetBufferParameterui64vNV(int target, int pname, long[] params) {
        long __functionAddress = GL.getCapabilities().glGetBufferParameterui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetNamedBufferParameterui64vNV(int buffer, int pname, long[] params) {
        long __functionAddress = GL.getCapabilities().glGetNamedBufferParameterui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, buffer, pname, params);
    }

    public static void glGetIntegerui64vNV(int value, long[] result) {
        long __functionAddress = GL.getCapabilities().glGetIntegerui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(result, 1);
        }
        JNI.callPV(__functionAddress, value, result);
    }

    public static void glUniformui64vNV(int location, long[] value) {
        long __functionAddress = GL.getCapabilities().glUniformui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length, value);
    }

    public static void glGetUniformui64vNV(int program, int location, long[] params) {
        long __functionAddress = GL.getCapabilities().glGetUniformui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glProgramUniformui64vNV(int program, int location, long[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformui64vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }
}

