/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class INTELPerformanceQuery {
    public static final int GL_PERFQUERY_SINGLE_CONTEXT_INTEL = 0;
    public static final int GL_PERFQUERY_GLOBAL_CONTEXT_INTEL = 1;
    public static final int GL_PERFQUERY_WAIT_INTEL = 33787;
    public static final int GL_PERFQUERY_FLUSH_INTEL = 33786;
    public static final int GL_PERFQUERY_DONOT_FLUSH_INTEL = 33785;
    public static final int GL_PERFQUERY_COUNTER_EVENT_INTEL = 38128;
    public static final int GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL = 38129;
    public static final int GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL = 38130;
    public static final int GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL = 38131;
    public static final int GL_PERFQUERY_COUNTER_RAW_INTEL = 38132;
    public static final int GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL = 38133;
    public static final int GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL = 38136;
    public static final int GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL = 38137;
    public static final int GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL = 38138;
    public static final int GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL = 38139;
    public static final int GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL = 38140;
    public static final int GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL = 38141;
    public static final int GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL = 38142;
    public static final int GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL = 38143;
    public static final int GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL = 38144;

    protected INTELPerformanceQuery() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glBeginPerfQueryINTEL, caps.glCreatePerfQueryINTEL, caps.glDeletePerfQueryINTEL, caps.glEndPerfQueryINTEL, caps.glGetFirstPerfQueryIdINTEL, caps.glGetNextPerfQueryIdINTEL, caps.glGetPerfCounterInfoINTEL, caps.glGetPerfQueryDataINTEL, caps.glGetPerfQueryIdByNameINTEL, caps.glGetPerfQueryInfoINTEL);
    }

    public static void glBeginPerfQueryINTEL(int queryHandle) {
        long __functionAddress = GL.getCapabilities().glBeginPerfQueryINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, queryHandle);
    }

    public static void nglCreatePerfQueryINTEL(int queryId, long queryHandle) {
        long __functionAddress = GL.getCapabilities().glCreatePerfQueryINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, queryId, queryHandle);
    }

    public static void glCreatePerfQueryINTEL(int queryId, IntBuffer queryHandle) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryHandle, 1);
        }
        INTELPerformanceQuery.nglCreatePerfQueryINTEL(queryId, MemoryUtil.memAddress(queryHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreatePerfQueryINTEL(int queryId) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer queryHandle = stack.callocInt(1);
            INTELPerformanceQuery.nglCreatePerfQueryINTEL(queryId, MemoryUtil.memAddress(queryHandle));
            int n = queryHandle.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDeletePerfQueryINTEL(int queryHandle) {
        long __functionAddress = GL.getCapabilities().glDeletePerfQueryINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, queryHandle);
    }

    public static void glEndPerfQueryINTEL(int queryHandle) {
        long __functionAddress = GL.getCapabilities().glEndPerfQueryINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, queryHandle);
    }

    public static void nglGetFirstPerfQueryIdINTEL(long queryId) {
        long __functionAddress = GL.getCapabilities().glGetFirstPerfQueryIdINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, queryId);
    }

    public static void glGetFirstPerfQueryIdINTEL(IntBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryId, 1);
        }
        INTELPerformanceQuery.nglGetFirstPerfQueryIdINTEL(MemoryUtil.memAddress(queryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFirstPerfQueryIdINTEL() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer queryId = stack.callocInt(1);
            INTELPerformanceQuery.nglGetFirstPerfQueryIdINTEL(MemoryUtil.memAddress(queryId));
            int n = queryId.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetNextPerfQueryIdINTEL(int queryId, long nextQueryId) {
        long __functionAddress = GL.getCapabilities().glGetNextPerfQueryIdINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, queryId, nextQueryId);
    }

    public static void glGetNextPerfQueryIdINTEL(int queryId, IntBuffer nextQueryId) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)nextQueryId, 1);
        }
        INTELPerformanceQuery.nglGetNextPerfQueryIdINTEL(queryId, MemoryUtil.memAddress(nextQueryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetNextPerfQueryIdINTEL(int queryId) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer nextQueryId = stack.callocInt(1);
            INTELPerformanceQuery.nglGetNextPerfQueryIdINTEL(queryId, MemoryUtil.memAddress(nextQueryId));
            int n = nextQueryId.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetPerfCounterInfoINTEL(int queryId, int counterId, int counterNameLength, long counterName, int counterDescLength, long counterDesc, long counterOffset, long counterDataSize, long counterTypeEnum, long counterDataTypeEnum, long rawCounterMaxValue) {
        long __functionAddress = GL.getCapabilities().glGetPerfCounterInfoINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPPPPPV(__functionAddress, queryId, counterId, counterNameLength, counterName, counterDescLength, counterDesc, counterOffset, counterDataSize, counterTypeEnum, counterDataTypeEnum, rawCounterMaxValue);
    }

    public static void glGetPerfCounterInfoINTEL(int queryId, int counterId, ByteBuffer counterName, ByteBuffer counterDesc, IntBuffer counterOffset, IntBuffer counterDataSize, IntBuffer counterTypeEnum, IntBuffer counterDataTypeEnum, LongBuffer rawCounterMaxValue) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)counterOffset, 1);
            Checks.checkBuffer((Buffer)counterDataSize, 1);
            Checks.checkBuffer((Buffer)counterTypeEnum, 1);
            Checks.checkBuffer((Buffer)counterDataTypeEnum, 1);
            Checks.checkBuffer((Buffer)rawCounterMaxValue, 1);
        }
        INTELPerformanceQuery.nglGetPerfCounterInfoINTEL(queryId, counterId, counterName.remaining(), MemoryUtil.memAddress(counterName), counterDesc.remaining(), MemoryUtil.memAddress(counterDesc), MemoryUtil.memAddress(counterOffset), MemoryUtil.memAddress(counterDataSize), MemoryUtil.memAddress(counterTypeEnum), MemoryUtil.memAddress(counterDataTypeEnum), MemoryUtil.memAddress(rawCounterMaxValue));
    }

    public static void nglGetPerfQueryDataINTEL(int queryHandle, int flags, int dataSize, long data, long bytesWritten) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryDataINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, queryHandle, flags, dataSize, data, bytesWritten);
    }

    public static void glGetPerfQueryDataINTEL(int queryHandle, int flags, ByteBuffer data, IntBuffer bytesWritten) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)bytesWritten, 1);
        }
        INTELPerformanceQuery.nglGetPerfQueryDataINTEL(queryHandle, flags, data.remaining(), MemoryUtil.memAddress(data), MemoryUtil.memAddress(bytesWritten));
    }

    public static void nglGetPerfQueryIdByNameINTEL(long queryName, long queryId) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryIdByNameINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, queryName, queryId);
    }

    public static void glGetPerfQueryIdByNameINTEL(ByteBuffer queryName, IntBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.checkNT1(queryName);
            Checks.checkBuffer((Buffer)queryId, 1);
        }
        INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(MemoryUtil.memAddress(queryName), MemoryUtil.memAddress(queryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetPerfQueryIdByNameINTEL(CharSequence queryName, IntBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryId, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer queryNameEncoded = stack.ASCII(queryName);
            INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(MemoryUtil.memAddress(queryNameEncoded), MemoryUtil.memAddress(queryId));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetPerfQueryIdByNameINTEL(CharSequence queryName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer queryNameEncoded = stack.ASCII(queryName);
            IntBuffer queryId = stack.callocInt(1);
            INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(MemoryUtil.memAddress(queryNameEncoded), MemoryUtil.memAddress(queryId));
            int n = queryId.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetPerfQueryInfoINTEL(int queryId, int queryNameLength, long queryName, long dataSize, long noCounters, long noInstances, long capsMask) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryInfoINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPPPV(__functionAddress, queryId, queryNameLength, queryName, dataSize, noCounters, noInstances, capsMask);
    }

    public static void glGetPerfQueryInfoINTEL(int queryId, ByteBuffer queryName, IntBuffer dataSize, IntBuffer noCounters, IntBuffer noInstances, IntBuffer capsMask) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)dataSize, 1);
            Checks.checkBuffer((Buffer)noCounters, 1);
            Checks.checkBuffer((Buffer)noInstances, 1);
            Checks.checkBuffer((Buffer)capsMask, 1);
        }
        INTELPerformanceQuery.nglGetPerfQueryInfoINTEL(queryId, queryName.remaining(), MemoryUtil.memAddress(queryName), MemoryUtil.memAddress(dataSize), MemoryUtil.memAddress(noCounters), MemoryUtil.memAddress(noInstances), MemoryUtil.memAddress(capsMask));
    }

    public static void glCreatePerfQueryINTEL(int queryId, int[] queryHandle) {
        long __functionAddress = GL.getCapabilities().glCreatePerfQueryINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(queryHandle, 1);
        }
        JNI.callPV(__functionAddress, queryId, queryHandle);
    }

    public static void glGetFirstPerfQueryIdINTEL(int[] queryId) {
        long __functionAddress = GL.getCapabilities().glGetFirstPerfQueryIdINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(queryId, 1);
        }
        JNI.callPV(__functionAddress, queryId);
    }

    public static void glGetNextPerfQueryIdINTEL(int queryId, int[] nextQueryId) {
        long __functionAddress = GL.getCapabilities().glGetNextPerfQueryIdINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(nextQueryId, 1);
        }
        JNI.callPV(__functionAddress, queryId, nextQueryId);
    }

    public static void glGetPerfCounterInfoINTEL(int queryId, int counterId, ByteBuffer counterName, ByteBuffer counterDesc, int[] counterOffset, int[] counterDataSize, int[] counterTypeEnum, int[] counterDataTypeEnum, long[] rawCounterMaxValue) {
        long __functionAddress = GL.getCapabilities().glGetPerfCounterInfoINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(counterOffset, 1);
            Checks.checkBuffer(counterDataSize, 1);
            Checks.checkBuffer(counterTypeEnum, 1);
            Checks.checkBuffer(counterDataTypeEnum, 1);
            Checks.checkBuffer(rawCounterMaxValue, 1);
        }
        JNI.callPPPPPPPV(__functionAddress, queryId, counterId, counterName.remaining(), MemoryUtil.memAddress(counterName), counterDesc.remaining(), MemoryUtil.memAddress(counterDesc), counterOffset, counterDataSize, counterTypeEnum, counterDataTypeEnum, rawCounterMaxValue);
    }

    public static void glGetPerfQueryDataINTEL(int queryHandle, int flags, ByteBuffer data, int[] bytesWritten) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryDataINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(bytesWritten, 1);
        }
        JNI.callPPV(__functionAddress, queryHandle, flags, data.remaining(), MemoryUtil.memAddress(data), bytesWritten);
    }

    public static void glGetPerfQueryIdByNameINTEL(ByteBuffer queryName, int[] queryId) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryIdByNameINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkNT1(queryName);
            Checks.checkBuffer(queryId, 1);
        }
        JNI.callPPV(__functionAddress, MemoryUtil.memAddress(queryName), queryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetPerfQueryIdByNameINTEL(CharSequence queryName, int[] queryId) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryIdByNameINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(queryId, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer queryNameEncoded = stack.ASCII(queryName);
            JNI.callPPV(__functionAddress, MemoryUtil.memAddress(queryNameEncoded), queryId);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetPerfQueryInfoINTEL(int queryId, ByteBuffer queryName, int[] dataSize, int[] noCounters, int[] noInstances, int[] capsMask) {
        long __functionAddress = GL.getCapabilities().glGetPerfQueryInfoINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(dataSize, 1);
            Checks.checkBuffer(noCounters, 1);
            Checks.checkBuffer(noInstances, 1);
            Checks.checkBuffer(capsMask, 1);
        }
        JNI.callPPPPPV(__functionAddress, queryId, queryName.remaining(), MemoryUtil.memAddress(queryName), dataSize, noCounters, noInstances, capsMask);
    }
}

