/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRReusableSync {
    public static final int EGL_SYNC_STATUS_KHR = 12529;
    public static final int EGL_SIGNALED_KHR = 12530;
    public static final int EGL_UNSIGNALED_KHR = 12531;
    public static final int EGL_TIMEOUT_EXPIRED_KHR = 12533;
    public static final int EGL_CONDITION_SATISFIED_KHR = 12534;
    public static final int EGL_SYNC_TYPE_KHR = 12535;
    public static final int EGL_SYNC_REUSABLE_KHR = 12538;
    public static final int EGL_SYNC_FLUSH_COMMANDS_BIT_KHR = 1;
    public static final long EGL_FOREVER_KHR = -1L;
    public static final long EGL_NO_SYNC_KHR = 0L;

    protected KHRReusableSync() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateSyncKHR, caps.eglDestroySyncKHR, caps.eglClientWaitSyncKHR, caps.eglSignalSyncKHR, caps.eglGetSyncAttribKHR);
    }

    public static long neglCreateSyncKHR(long dpy, int type, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPP(__functionAddress, dpy, type, attrib_list);
    }

    public static long eglCreateSyncKHR(long dpy, int type, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return KHRReusableSync.neglCreateSyncKHR(dpy, type, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static boolean eglDestroySyncKHR(long dpy, long sync) {
        long __functionAddress = EGL.getCapabilities().eglDestroySyncKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPI(__functionAddress, dpy, sync) != 0;
    }

    public static int eglClientWaitSyncKHR(long dpy, long sync, int flags, long timeout) {
        long __functionAddress = EGL.getCapabilities().eglClientWaitSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPJI(__functionAddress, dpy, sync, flags, timeout);
    }

    public static boolean eglSignalSyncKHR(long dpy, long sync, int mode) {
        long __functionAddress = EGL.getCapabilities().eglSignalSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPI(__functionAddress, dpy, sync, mode) != 0;
    }

    public static int neglGetSyncAttribKHR(long dpy, long sync, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglGetSyncAttribKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPPI(__functionAddress, dpy, sync, attribute, value);
    }

    public static boolean eglGetSyncAttribKHR(long dpy, long sync, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return KHRReusableSync.neglGetSyncAttribKHR(dpy, sync, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static long eglCreateSyncKHR(long dpy, int type, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
        }
        return JNI.callPPP(__functionAddress, dpy, type, attrib_list);
    }

    public static boolean eglGetSyncAttribKHR(long dpy, long sync, int attribute, int[] value) {
        long __functionAddress = EGL.getCapabilities().eglGetSyncAttribKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
            Checks.checkBuffer(value, 1);
        }
        return JNI.callPPPI(__functionAddress, dpy, sync, attribute, value) != 0;
    }
}

