/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTOutputBase {
    public static final int EGL_BAD_OUTPUT_LAYER_EXT = 12845;
    public static final int EGL_BAD_OUTPUT_PORT_EXT = 12846;
    public static final int EGL_SWAP_INTERVAL_EXT = 12847;
    public static final long EGL_NO_OUTPUT_LAYER_EXT = 0L;
    public static final long EGL_NO_OUTPUT_PORT_EXT = 0L;

    protected EXTOutputBase() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglGetOutputLayersEXT, caps.eglGetOutputPortsEXT, caps.eglOutputLayerAttribEXT, caps.eglQueryOutputLayerAttribEXT, caps.eglQueryOutputLayerStringEXT, caps.eglOutputPortAttribEXT, caps.eglQueryOutputPortAttribEXT, caps.eglQueryOutputPortStringEXT);
    }

    public static int neglGetOutputLayersEXT(long dpy, long attrib_list, long layers, int max_layers, long num_layers) {
        long __functionAddress = EGL.getCapabilities().eglGetOutputLayersEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPPPI(__functionAddress, dpy, attrib_list, layers, max_layers, num_layers);
    }

    public static boolean eglGetOutputLayersEXT(long dpy, PointerBuffer attrib_list, PointerBuffer layers, IntBuffer num_layers) {
        if (Checks.CHECKS) {
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344L);
            }
            Checks.checkBuffer((Buffer)num_layers, 1);
        }
        return EXTOutputBase.neglGetOutputLayersEXT(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(layers), layers == null ? 0 : layers.remaining(), MemoryUtil.memAddress(num_layers)) != 0;
    }

    public static int neglGetOutputPortsEXT(long dpy, long attrib_list, long ports, int max_ports, long num_ports) {
        long __functionAddress = EGL.getCapabilities().eglGetOutputPortsEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPPPI(__functionAddress, dpy, attrib_list, ports, max_ports, num_ports);
    }

    public static boolean eglGetOutputPortsEXT(long dpy, PointerBuffer attrib_list, PointerBuffer ports, IntBuffer num_ports) {
        if (Checks.CHECKS) {
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344L);
            }
            Checks.checkBuffer((Buffer)num_ports, 1);
        }
        return EXTOutputBase.neglGetOutputPortsEXT(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(ports), ports == null ? 0 : ports.remaining(), MemoryUtil.memAddress(num_ports)) != 0;
    }

    public static boolean eglOutputLayerAttribEXT(long dpy, long layer, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglOutputLayerAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(layer);
        }
        return JNI.callPPPI(__functionAddress, dpy, layer, attribute, value) != 0;
    }

    public static int neglQueryOutputLayerAttribEXT(long dpy, long layer, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryOutputLayerAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(layer);
        }
        return JNI.callPPPI(__functionAddress, dpy, layer, attribute, value);
    }

    public static boolean eglQueryOutputLayerAttribEXT(long dpy, long layer, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return EXTOutputBase.neglQueryOutputLayerAttribEXT(dpy, layer, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static long neglQueryOutputLayerStringEXT(long dpy, long layer, int name) {
        long __functionAddress = EGL.getCapabilities().eglQueryOutputLayerStringEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(layer);
        }
        return JNI.callPPP(__functionAddress, dpy, layer, name);
    }

    public static String eglQueryOutputLayerStringEXT(long dpy, long layer, int name) {
        long __result = EXTOutputBase.neglQueryOutputLayerStringEXT(dpy, layer, name);
        return MemoryUtil.memASCII(__result);
    }

    public static boolean eglOutputPortAttribEXT(long dpy, long port, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglOutputPortAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(port);
        }
        return JNI.callPPPI(__functionAddress, dpy, port, attribute, value) != 0;
    }

    public static int neglQueryOutputPortAttribEXT(long dpy, long port, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryOutputPortAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(port);
        }
        return JNI.callPPPI(__functionAddress, dpy, port, attribute, value);
    }

    public static boolean eglQueryOutputPortAttribEXT(long dpy, long port, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return EXTOutputBase.neglQueryOutputPortAttribEXT(dpy, port, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static long neglQueryOutputPortStringEXT(long dpy, long port, int name) {
        long __functionAddress = EGL.getCapabilities().eglQueryOutputPortStringEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(port);
        }
        return JNI.callPPP(__functionAddress, dpy, port, name);
    }

    public static String eglQueryOutputPortStringEXT(long dpy, long port, int name) {
        long __result = EXTOutputBase.neglQueryOutputPortStringEXT(dpy, port, name);
        return MemoryUtil.memASCII(__result);
    }

    public static boolean eglGetOutputLayersEXT(long dpy, PointerBuffer attrib_list, PointerBuffer layers, int[] num_layers) {
        long __functionAddress = EGL.getCapabilities().eglGetOutputLayersEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344L);
            }
            Checks.checkBuffer(num_layers, 1);
        }
        return JNI.callPPPPI(__functionAddress, dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(layers), layers == null ? 0 : layers.remaining(), num_layers) != 0;
    }

    public static boolean eglGetOutputPortsEXT(long dpy, PointerBuffer attrib_list, PointerBuffer ports, int[] num_ports) {
        long __functionAddress = EGL.getCapabilities().eglGetOutputPortsEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344L);
            }
            Checks.checkBuffer(num_ports, 1);
        }
        return JNI.callPPPPI(__functionAddress, dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(ports), ports == null ? 0 : ports.remaining(), num_ports) != 0;
    }
}

