(ns lein-docker-compose.plugin
  (:use [robert.hooke :only (add-hook)])
  (:require [yaml.core :as yaml]
            [clojure.edn :as edn]
            [clojure.java.io :as io]
            [clojure.java.shell :as sh]
            [clojure.string :as s]
            [lein-environ.plugin]))

(defn discover-docker-ports
  [project]
  (let [docker-env (io/file (:root project) ".lein-docker-env")]
    (if (.exists docker-env)
      (edn/read-string (slurp docker-env))
      (println "Couldn't find .lein-docker-env - have you added docker-compose as a prep-task in your project.clj?"))))

(defn merge-docker-env-vars
  [func project]
  (merge (func project)
         (discover-docker-ports project)))

(defn hooks []
  (add-hook #'lein-environ.plugin/read-env #'merge-docker-env-vars))
