(ns gram-api.ll
  (:require [clj-http.lite.client :as client]))


(defn call-api- [url query-params]
  (client/get (str "https://api.telegram.org/bot" url)
              {:query-params         query-params
               :throw-exceptions     false
               :ignore-unknown-host? true}))

(defn send-message [api-key query-params]
  (call-api- (str api-key "/sendMessage") query-params))

(defn get-updates [api-key query-params]
  (call-api- (str api-key "/getUpdates") query-params))

