# cloud-pubsub-batch-publisher [![CircleCI](https://dl.circleci.com/status-badge/img/gh/hden/cloud-pubsub-batch-publisher/tree/master.svg?style=svg)](https://dl.circleci.com/status-badge/redirect/gh/hden/cloud-pubsub-batch-publisher/tree/master)

A batch publisher for Google Cloud PubSub.

## Installation

```clj
[hden/cloud-pubsub-batch-publisher "1.1.1"]
```

## Usage

```clj
(require '[cloud-pubsub-batch-publisher.core :as pubsub])

(def publisher (pubsub/publisher "TOPIC-NAME")

;; In a single publish request, all messages must have no ordering key
;; or they must all have the same ordering key.
;; See https://cloud.google.com/pubsub/docs/ordering
(def messages
  [{:message      "MESSAGE"       ;; String, required
    :metadata     {"KEY" "VALUE"} ;; Map<String, String>, optional
    :ordering-key "KEY"}])        ;; String, optional

(pubsub/publish! publisher {:messages messages})

(pubsub/shutdown! publisher {:await-msec 1000})
```

## License

Copyright © 2021 Haokang Den
