(ns ouroboros.dummy)

(defn add [x y]
  (+ x y))

(do
  (require '[sparkling.conf :as conf])
  (require '[sparkling.core :as spark])
  (spark/with-context sc (-> (conf/spark-conf)              ; this creates a spark context from the given context
                             (conf/app-name "sparkling-test")
                             (conf/master "local"))
                      (let [lines-rdd (spark/into-rdd sc ["This is a firest line"   ;; here we provide data from a clojure collection.
                                                          "Testing spark"           ;; You could also read from a text file, or avro file.
                                                          "and sparkling"           ;; You could even approach a JDBC datasource
                                                          "Happy hacking!"])]
                        (spark/collect                      ;; get every element from the filtered RDD
                          (spark/filter                     ;; filter elements in the given RDD (lines-rdd)
                            #(.contains % "spark")          ;; a pure clojure function as filter predicate
                            lines-rdd)))))

(into []
  (keg/rdd ["This is a firest line"   ;; here we provide data from a clojure collection.
           "Testing spark"           ;; You could also read from a text file, or avro file.
           "and powderkeg"           ;; You could even approach a JDBC datasource
           "Happy hacking!"]
   (filter #(.contains % "spark"))))