(ns <<project-ns>>.modules.sys.auth-service
  (:require
   [clojure.tools.logging :as log]
   [<<project-ns>>.common.token :as token]
   [<<project-ns>>.common.encrypt :as encrypt]
   [<<project-ns>>.modules.sys.sys-user-db :as db]
   [<<project-ns>>.common.biz-error :refer [throw-error biz-error-map]]))
 
(defn get-token [{:keys [username password]}]
  (if-let [user (db/find-sys-user {:username username :password (encrypt/encode password)})]
    (token/get-token (select-keys user [:user-id :username :nickname :company-id]))
    (throw-error 1000)))

(defn refresh-token [refresh-token-str]
  (if (token/valid-refresh-token? refresh-token-str)
    (token/refresh-token refresh-token-str)
    (throw-error 1001)))
