(ns <<project-ns>>.url
  (:require 
   [<<project-ns>>.config :refer [domain]]))

;;授权相关url
(def auth-url
  {:token (str domain "/admin/public/auth/token")
   :refresh-token (str domain "/admin/public/auth/refresh-token")})

;;基础数据url
(def base-url
  {:company (str domain "/admin/base/company/detail")})

;;系统管理url
(def sys-url
  {:user-list (str domain "/admin/sys-user/page")
   :user-add (str domain "/admin/sys-user/save")
   :user-update (str domain "/admin/sys-user/update")
   :user-remove #(str domain "/admin/sys-user/remove/" %)
   :user-password (str domain "/admin/sys-user/change-pwd")})

;;商品相关url
(def product-url
  {:search (str domain "/admin/product/search")
   :categories (str domain "/admin/product/categorys")
   :detail #(str domain "/admin/product/detail/" %)
   :add (str domain "/admin/product/add")
   :update #(str domain "/admin/product/update/" %)
   :remove #(str domain "/admin/product/remove/" %)
   :recommend (str domain "/admin/product/recommend")
   :on-off (str domain "/admin/product/up_down")})
