(ns <<project-ns>>.product.product-list-views
  (:require
   ["antd" :as ant]
   ["moment" :as moment]
   [kee-frame.core :as kf]
   [reagent.core :as r]
   [re-frame.core :as rf]
   [<<project-ns>>.common.utils :as utils]
   [<<project-ns>>.components.common-page :refer [main-page pagination-table image-preview]]
   [<<project-ns>>.product.product-events :as events]
   [<<project-ns>>.product.product-sub :as sub]))

(def FormItem (.-Item ant/Form))
(def SelectOption (.-Option ant/Select))

(defn word-break [text]
  [:div {:style {:word-wrap "break-word" :word-break "break-all"}} text])

(def columns [{:title "图片"
               :dataIndex "image_url"
               :render
               #(r/as-element
                 [image-preview {:src % :style {:width 40 :height 50}}])}
              {:title "名称"
               :dataIndex "product_name"
               :width 100
               :render #(r/as-element [word-break %])}
              {:title "编号"
               :dataIndex "product_no"
               :width 90
               :render #(r/as-element [word-break %])}
              {:title "价格" :dataIndex "sales_price"}
              #_{:title "销量" :dataIndex "sales"}
              #_{:title "库存" :dataIndex "stock"}
              #_{:title "访问量" :dataIndex "visit"}
              {:title "排序" :dataIndex "show_type"}
              {:title "创建时间"
               :dataIndex "create_time"
               :width 108
               :render #(r/as-element [word-break (.format (.unix moment %) "YYYY/MM/DD")])}
              {:title "上下架"
               :dataIndex "product_status"
               :render
               (fn [val row]
                 (r/as-element
                  (let [values (js->clj row :keywordize-keys true)]
                    [:div
                     [:> ant/Switch {:checked (= "1" val)
                                     :checkedChildren "上架"
                                     :unCheckedChildren "下架"
                                     :onChange
                                     (fn [checked]
                                       (rf/dispatch
                                        [:product/on-off
                                         {:product_id
                                          (:product_id values)
                                          :product_status
                                          (if checked "1" "0")}]))}]])))}
              {:title "推荐"
               :dataIndex "recommend_type"
               :render
               (fn [val row]
                 (r/as-element
                  (let [values (js->clj row :keywordize-keys true)]
                    [:div
                     [:> ant/Switch {:checked (= "1" val)
                                     :checkedChildren "推荐"
                                     :unCheckedChildren "不推荐"
                                     :onChange
                                     (fn [checked]
                                       (rf/dispatch
                                        [:product/recommend
                                         {:product_id
                                          (:product_id values)
                                          :recommend_type
                                          (if checked "1" "0")}]))}]])))}
              {:title "操作"
               :dataIndex "action"
               :width 90
               :render
               (fn [val row index]
                 (r/as-element
                  [:div
                   [:a {:href (str "/main/product/info?id=" (:product_id (js->clj row :keywordize-keys true)))}
                    "编辑"]
                   [:> ant/Divider {:type "vertical"}]
                   [:> ant/Popconfirm
                    {:title "确定删除？"
                     :okText "确定"
                     :cancleText "取消"
                     :onConfirm #(rf/dispatch [:product/remove
                                               (:product_id (js->clj row :keywordize-keys true))])}
                    [:a "删除"]]]))}])

(defn product-table-search []
  (utils/create-form
   (fn [props]
     (let [this (utils/get-form)]
       [:> ant/Form {:layout "inline"
                     :onSubmit (fn [e]
                                 (.preventDefault e)
                                 ((:validateFields this)
                                  (fn [err values]
                                    (rf/dispatch [:product/fetch-list
                                                  (into {:page 0 :size 10} (remove (fn [[k v]] (nil? v)) (js->clj values)))]))))}
        [:> ant/Row {:gutter 1}
         [:> ant/Col {:md 4}
          [:> FormItem
           (utils/decorate-field
            this "product_name"
            [:> ant/Input
             {:allowClear true
              :placeholder "商品名称"}])]]
         [:> ant/Col {:md 4}
          [:> FormItem
           (utils/decorate-field
            this "product_no"
            [:> ant/Input
             {:placeholder "商品编号"
              :allowClear true}])]]
         [:> ant/Col {:md 4}
          [:> FormItem
           (utils/decorate-field
            this "product_status"
            [:> ant/Select
             {:style {:width 120}
              :placeholder "上下架"
              :allowClear true}
             [:> SelectOption {:value "1"} "上架"]
             [:> SelectOption {:value "0"} "下架"]])]]
         [:> ant/Col {:md 4}
          [:> FormItem
           (utils/decorate-field
            this "recommend_type"
            [:> ant/Select
             {:style {:width 120}
              :placeholder "是否推荐"
              :allowClear true}
             [:> SelectOption {:value "1"} "推荐"]
             [:> SelectOption {:value "0"} "不推荐"]])]]
         [:> ant/Col {:md 4}
          [:> FormItem
           (utils/decorate-field
            this "suit_type"
            [:> ant/Select
             {:style {:width 120}
              :placeholder "单品套装"
              :allowClear true}
             [:> SelectOption {:value "0"} "单品"]
             [:> SelectOption {:value "1"} "套装"]])]]
         [:> ant/Col {:md 4}
          [:> FormItem
           [:> ant/Button {:type "primary" :htmlType "submit"} "查询"]
           [:> ant/Button
            {:style {:margin-left 10}
             :on-click (fn []
                         ((:resetFields this))
                         (rf/dispatch [:product/fetch-list nil]))} "重置"]]]]]))))

(defn product-list-page []
  (def product-table (rf/subscribe [:product-sub/product-table]))
  (fn []
    [main-page {:title "商品列表"
                :extra (r/as-element
                        [:a {:href "/main/product/info"}
                         [:> ant/Button
                          {:type "primary"
                           :icon "plus"
                           :style {:float "right"}} "新建"]])}
     [:div
      [:> ant/Row {:style {:margin-bottom 20}}
       [:> ant/Col {:span 22}
        [product-table-search]]]
      [pagination-table
       {:rowKey "product_id"
        :columns columns
        :loading (or (:loading @product-table) false)
        :dataSource (or (:datas @product-table) [])
        :pagination (or (:pagination @product-table) {})
        :on-size-change (fn [current size]
                          (rf/dispatch [:product/fetch-list {:page (dec current) :size size}]))
        :on-change (fn [{:keys [current pageSize] :as pagination}]
                     (rf/dispatch [:product/fetch-list {:page (dec current) :size pageSize}]))}]]]))
