(ns <<project-ns>>.product.product-form-component
  (:require
   ["antd" :as ant]
   ["uuid" :as uid]
   [reagent.core :as r]
   [re-frame.core :as rf]
   [<<project-ns>>.components.search-product :refer [search-product-view]]))

(def FormItem (.-Item ant/Form))
(def Option (.-Option ant/Select))
(def RadioGroup (.-Group ant/Radio))

(def suit-products (rf/subscribe [:product/detail-suit-products]))

(def columns [{:title "名称" :width 150 :dataIndex "product_name"}
              {:title "编号" :width 150 :dataIndex "product_no"}
              {:title "价格" :dataIndex "sales_price"}
              {:title "操作" :render (fn [_ row]
                                       (r/as-element
                                        (let [values (js->clj row :keywordize-keys true)]
                                          [:a
                                           {:on-click
                                            #(rf/dispatch [:product/remove-suite-product values])}
                                           "移除"])))}])
(defn- suit-products-table-title []
  [:> ant/Row {:type "flex" :justify "space-between"}
   [:> ant/Col {:span 4}
    [:h4 "套装商品"]]
   [:> ant/Col {:span 3}
    [:> ant/Button
     {:ghost true
      :type "primary"
      :size "small"
      :on-click #(rf/dispatch [:search-product/open @suit-products {:suit_type "0"}])}
     "添加"]]])

(defn suit-products-table []
  (fn []
    [:div
     [:> ant/Table {:title #(r/as-element [suit-products-table-title])
                    :columns columns
                    :dataSource (or @suit-products [])
                    :pagination false
                    :size "small"}]
     [search-product-view
      {:on-ok #(rf/dispatch [:product/update-suit-products
                             (map
                              (fn [item]
                                (select-keys item [:product_id :product_name :product_no :custom_type :sales_price]))
                              %)])}]]))

(defn custom-list [{:keys [item-data show-default? show-price? price-disable? on-item-change]}]
  [:> ant/Row
   (for [data item-data]
     (do
       [:> ant/Col
        {:style {:margin-bottom 15} :span 4}
        (let [width 80]
          [:div
           [:> ant/Avatar
            {:shape "square"
             :size width
             :icon "file-image"
             :src (:img data)}]
           [:div
            {:style {:width width
                     :font-size 8
                     :color "#BEBEBE"
                     :margin "3px 0"
                     :text-align "center"}}
            (let [title (:value data)]
              (if (< (count title) 8)
                (identity title)
                [:> ant/Tooltip {:title title}
                 (str (subs title 0 6) "..")]))]
           (when (if (nil? show-price?) true show-price?)
             [:> ant/InputNumber
              {:value (:price data)
               :disabled (if (nil? price-disable?) false price-disable?)
               :prefix "￥"
               :formatter (fn [value] (str "￥" value))
               :parser #(clojure.string/replace % #"￥" "")
               :size "small"
               :onChange (fn [value]
                           (when on-item-change
                             (on-item-change
                              (assoc data :price value))))
               :style {:font-size 8
                       :margin-bottom 3
                       :width width}}])
           (when (if (nil? show-default? ) false show-default?)
             [:> ant/Row {:type "flex" :justify "center"}
              [:> ant/Col {:span 19}
               [:> ant/Switch {:checked (:default? data)
                               :size "small"
                               :checkedChildren "默认"
                               :onChange (fn [checked]
                                           (when on-item-change
                                             (on-item-change (assoc data :default? checked))))}]]])])]))])

(defn custom-select [{:keys [title placeholder allow-clear
                             select-data select-values select-loading
                             on-select-change on-select on-deselect]}]
  [:> ant/Row
   [:> ant/Col {:span 24}
    [:> FormItem {:label title
                  :labelCol {:span 3}
                  :wrapperCol {:span 18}}
     [:> ant/Select
      (merge
       {:mode "multiple"
        :allowClear (if (nil? allow-clear) false allow-clear)
        :value (or select-values [])
        :loading (or select-loading false)
        :placeholder (or placeholder "请选择")}
       (when on-select-change
         {:onChange (fn [_ option] (let [data (map #(:ref %) (js->clj option :keywordize-keys true))]
                                    (on-select-change data)))})
       (when on-select
         {:onSelect (fn [_ option] (on-select (:ref (js->clj option :keywordize-keys true))))})
       (when on-deselect
         {:onDeselect (fn [_ option]
                        (on-deselect (:ref (js->clj option :keywordize-keys true))))}))
      (for [{:keys [id value] :as data} select-data]
        [:> Option {:key id :value value :ref data} value])]]]])

(defn custom-select-item [props]
  [:div
   [custom-select props]
   [:> ant/Row
    [:> ant/Col {:span 20 :offset 3}
     [custom-list props]]]])

(defn custom-radio [{:keys [custom? on-radio-change]}]
  [:> ant/Row
   [:> ant/Col {:span 24}
    [:> FormItem {:label "是否定制"
                  :labelCol {:span 3}
                  :wrapperCol {:span 18}}
     [:> RadioGroup
      {:value (if (nil? custom?) true custom?)
       :onChange
       (fn [e]
         (let [value (-> (js->clj e :keywordize-keys true) :target :value)]
           (when on-radio-change (on-radio-change value))))}
      [:> ant/Radio {:value true} "定制"]
      [:> ant/Radio {:value false} "不定制"]]]]])

(defn parameter-input [{:keys [value onChange]}]
  (defn add-param [params]
    (concat (or params []) [{:key "" :value "" :id (.v1 uid)}]))
  (defn remove-param [param params]
    (remove #(= (:id %) (:id param)) params))
  (defn update-param [param params]
    (map (fn [item] (if (= (:id item) (:id param)) param item)) params))
  (let [params (js->clj value :keywordize-keys true)]
    [:div
     (when (or (nil? params) (zero? (count params)))
       [:> ant/Button {:ghost true
                       :type "primary"
                       :shape "circle"
                       :icon "plus"
                       :size "small"
                       :on-click #(onChange (add-param params))}])
     (map-indexed
      (fn [idx itm]
        [:div {:key idx}
         [:> ant/Input {:value (get itm :key "")
                        :placeholder "名称"
                        :allowClear true
                        :style {:width 180}
                        :onChange #(onChange (update-param (assoc itm :key (-> % .-target .-value)) params))
                        }]
         [:> ant/Input {:value (get itm :value "")
                        :placeholder "值"
                        :allowClear true
                        :style {:width 180 :margin "0 15px"}
                        :onChange #(onChange (update-param (assoc itm :value (-> % .-target .-value)) params))
                        }]
         (when (and params (> (count params) 1))
           [:> ant/Button {:style {:margin-right 10}
                           :ghost true
                           :type "primary"
                           :shape "circle"
                           :icon "minus"
                           :size "small"
                           :on-click #(onChange (remove-param itm params))
                           }])
         (when (or (nil? itm) (= (inc idx) (count params)))
           [:> ant/Button {:ghost true
                           :type "primary"
                           :shape "circle"
                           :icon "plus"
                           :size "small"
                           :on-click #(onChange (add-param params))}])])
      params)]))
