(ns <<project-ns>>.product.product-data-convert
  (:require
   ["uuid" :as uid]
   [clojure.string :as string]))

(defn- boolean->str [b]
  (if b "1" "0"))

(defn- map-key-value [data]
  (map
   #(select-keys % [:key :value])
   (filter (fn [{:keys [key value]}] (and (not (string/blank? key)) (not (string/blank? value))))  data)))

(defn default-flag [default?]
  (if default? 1 0))

(defn fabrics->params [fabric-custom? fabrics]
  (if (= false fabric-custom?)
    (identity [])
    (map-indexed (fn [idx fabric]
                   {:fabric_id (:id fabric)
                    :fabric_name (:name fabric)
                    :fabric_code (:value fabric)
                    :fabric_price (or (:price fabric) 0)
                    :image_url (:img fabric)
                    :default_flag (boolean->str (:default? fabric))
                    :show_order idx}) fabrics)))

(defn default-fabric [fabrics]
  (or
   (first
    (map
     (fn [item] (select-keys item [:fabric_id :fabric_name :fabric_code :image_url]))
     (filter
      #(= (:default_flag %) "1") fabrics)))
   (identity {})))

(defn crafts->params [crafts]
  (map-indexed
   (fn [idx craft]
     {:craft_id (:id craft)
      :craft_name (:value craft)
      :craft_code (or (:code craft) "")
      :craft_image (:img craft)
      :craft_price (or (:price craft) 0)
      :default_flag (boolean->str (:default? craft))
      :show_order idx})
   crafts))

(defn position->params [positions  model-show]
  (map-indexed
   (fn [idx position]
     {:position_id (:id position)
      :position_name (:value position)
      :position_code ""
      :model_show model-show
      :show_order idx
      :craft_items (crafts->params (:selected-crafts position))})
   positions))

(defn positons->params [style-custom? style-positions deep-custom? deep-positions]
  (let [spositions (if (= false style-custom?) [] style-positions)
        dpositions (if (= false deep-custom?) [] deep-positions)]
    (concat
     (position->params spositions "1")
     (position->params dpositions "0"))))

(defn default-crafts [positions]
  (filter
   #(not (nil? %))
   (flatten
    (map
     (fn [position]
       (map
        (fn [craft]
          (when (= "1" (:default_flag craft))
            (merge
             (select-keys position [:position_id :position_name :position_code])
             (select-keys craft [:craft_id :craft_name :craft_code :craft_image]))))
        (:craft_items position)))
     positions))))

(defn embroidery-position->params [embroidery-custom? embroideries]
  (if (= false embroidery-custom?)
    (identity [])
    (map-indexed (fn [idx item]
                   {:position_id (:id item)
                    :position_name (:value item)
                    :position_code (or (:code item) "")
                    :position_image (or  (:img item) "")
                    :show_order idx}) embroideries)))

(defn product-db->request-params [db]
  (let [{:keys [product-name product-no category-ids
                sale-price vip-price suit-type suit-products
                cover-imgs banner-imgs detail-imgs custom-type
                params services product-intro remark recommend? online?
                fabric-custom? fabrics
                style-craftwork-custom? style-positions
                deep-craftwork-custom? deep-positions
                embroidery-custom? embroideries]} (get-in db [:product :detail])
        fabrics (fabrics->params fabric-custom? fabrics)
        craftworks (positons->params style-craftwork-custom? style-positions deep-craftwork-custom? deep-positions)]
    {:product {:product_type "1"
               :category_id (or (last category-ids) "")
               :recommend_type (boolean->str recommend?)
               :custom_type custom-type
               :product_name product-name
               :vip_price vip-price
               :product_no product-no
               :product_intro product-intro
               :show_type "0"
               :sales_price sale-price
               :suit_type suit-type
               :remark (or remark "")
               :image_url (or (:url (first cover-imgs) ""))
               :product_status (boolean->str online?)}
     :params (map-key-value params)
     :services (map-key-value services)
     :banner_images (map-indexed
                     (fn [idx itm] {:image_url (:url itm) :show_order idx})
                     banner-imgs)
     :detail_images (map-indexed (fn [idx itm] {:image_url (:url itm) :show_order idx})
                                 detail-imgs)
     :suit_items (if (= "0" suit-type) [] (or suit-products []))
     :custom_fabrics fabrics
     :custom_craftworks craftworks
     :default_data {:fabric (default-fabric fabrics)
                    :craftworks (default-crafts craftworks)}
     :custom_embroidery {:position (embroidery-position->params embroidery-custom? embroideries)
                         :font []
                         :color []}
     :custom_printing {:position []
                       :printing []}
     :colors []}))

(defn- str->boolean [s]
  (= "1" s))

(defn- db-images [imgs]  
  (map (fn [item] {:url (:image_url item)
                  :uid (.v1 uid)
                  :status "done"}) imgs))

(defn fabrics->db [fabrics]
  (map (fn [fabric]
         {:id (:fabric_id fabric)
          :value (:fabric_code fabric)
          :name (:fabric_name fabric)
          :img (:image_url fabric)
          :price (:fabric_price fabric)
          :default? (= (:default_flag fabric) "1")}) fabrics))

(defn embroideries->db [embroideries]
  (map (fn [item]
         {:id (:position_id item)
          :value (:position_name item)
          :code (:position_code item)
          :img (:position_image item)}) embroideries))

(defn crafts->db [crafts]
  (map
   (fn [item]
     {:id (:craft_id item)
      :code (:craft_code item)
      :value (:craft_name item)
      :img (:craft_image item)
      :price (:craft_price item)
      :default? (= "1" (:default_flag item))})
   crafts))

(defn style-positions->db [positions]
  (map
   (fn [item]
     {:id (:position_id item)
      :value (:position_name item)
      :code (:position_code item)
      :selected-crafts (crafts->db (:craft_items item))})
   (filter #(= "1" (:model_show %)) positions)))

(defn deep-positions->db [positions]
  (map
   (fn [item]
     {:id (:position_id item)
      :value (:position_name item)
      :code (:position_code item)
      :selected-crafts (crafts->db (:craft_items item))})
   (filter #(= "0" (:model_show %)) positions)))

(defn product-dtail->db [detail]
  {:current-step 0
   :loading false
   :custom-type (:custom_type detail)
   :product-custom (= (:custom_type detail) "2")
   :suit-products-visible (= "1" (:suit_type detail))
   :product-id (:product_id detail)
   :product-name (:product_name detail)
   :product-no (:product_no detail)
   :category-ids (:ids detail)
   :suit-type (:suit_type detail)
   :suit-products (:suit_items detail)
   :sale-price (:sales_price detail)
   :vip-price (:vip_price detail)
   :params (map #(assoc % :id (.v1 uid)) (:params detail))
   :services (map #(assoc % :id (.v1 uid)) (:services detail))
   :product-intro (:product_intro detail)
   :remark (:remark detail)
   :cover-imgs  (if (string/blank? (:image_url detail))
                  []
                  [{:url (:image_url detail)
                    :status "done"
                    :uid -1}])
   :banner-imgs (db-images (:banner_images detail))
   :detail-imgs (db-images (:detail_images detail))
   :online? (str->boolean (:product_status detail))
   :new? true
   :recommend? (str->boolean (:recommend_type detail))
   :fabrics (fabrics->db (:custom_fabrics detail))
   :embroideries (embroideries->db (get-in detail [:custom_embroidery :position] []))
   :style-positions (style-positions->db (:custom_craftworks detail))
   :deep-positions (deep-positions->db (:custom_craftworks detail))})
