(ns <<project-ns>>.layout.side-menu
  (:require [reagent.core :as r]
            [re-frame.core :as rf]
            [kee-frame.core :as kf]
            ["antd" :refer [Menu Icon]]))

(def SubMenu (.-SubMenu Menu))
(def MenuItem (.-Item Menu))

#_(defn- router->menu [route]
    (fn []
      (when route
        (let [[path data & children] route]
          (if (zero? (count children))
            [:> MenuItem {:key (:name data) :className "ant-menu-item"} (:title data)]
            [:> SubMenu {:key (:name data) :title (:title data)}
             (map #(vector (router->menu %)) children)])))))

(def open-keys (r/atom []))
(def selected-keys (r/atom []))


(defn create-side-menus [routes]
  (fn []
    [:> Menu {:theme "dark"
              :mode "inline"
              :openKeys @open-keys
              :selected-keys @selected-keys
              :onOpenChange (fn [openKeys]
                              (reset! open-keys (js->clj openKeys)))
              :onClick (fn [item]
                         (reset! selected-keys (:key (js->clj item :keywordize-keys true)) ))}

     (for [route routes
           :let [[path {:keys [name title icon show]} & children] route]
           :when (not= false show)]
       (if (zero? (count children))
         [:> MenuItem {:key name}
          [:a {:href (str "/main" path)}
           [:> Icon {:type icon}]
           [:span title]]]
         [:> SubMenu {:key name
                      :title (r/as-element [:span
                                            [:> Icon {:type icon}]
                                            [:span title]])}
          (for [child children
                :let [[cpath cdata] child]
                :when (not= false (:show cdata))]
            [:> MenuItem {:key (:name cdata)}
             [:a {:href (str "/main" path cpath)} (:title cdata)]])]))]))
