(ns <<project-ns>>.routes.service.file
  (:require
   [<<project-ns>>.config :refer [env]]
   [clojure.java.io :as io]
   [clj.qiniu :as qiniu]
   [clojure.tools.logging :as log]))


(defn- format-date-time [timestamp]
  (-> "yyyyMMddHHmmss"
      (java.text.SimpleDateFormat.)
      (.format timestamp)))

(defn upload-file-local
  "上传文件到本地指定目录
   env里指定file-path这个配置，可以是绝对路径，也可以是相对路径，有读写权限就可以
  此方法可以保留文件扩展名"
  [type file]
  (let [filename (:filename file)
        file-path (str (:file-path env) type
                       "/" (format-date-time (java.util.Date.))
                       "/" filename)
        fileType (subs filename (clojure.string/last-index-of filename ".") (count filename))]
    (io/make-parents file-path)
    (with-open [writer (io/output-stream file-path)]
      (io/copy (:tempfile file) writer))
    file-path))

;;上传到七牛配置
(def set-qiniu-config
  (qiniu/set-config! :access-key "Ci_VFCYmKwFGWgbIEFxTsGNd69amAaXtwiZr9vIR"
                     :secret-key "XSQNWYzsdcaiE9r68WyQQj13t1RpjuauMR_vx2JG"))

;;配置也可以从环境变量获取
(def qiniu-config
  {:bucket "medical"
   :domain "https://medical.3vyd.com/"
   :prefix "demo/tmp/"})

(defn qiniu-upload-path
  "构造上传地址"
  [type filename]
  (str (:prefix qiniu-config)
       type "/"
       (format-date-time (java.util.Date.))
       "/"
       filename))

;;七牛云上传，返回上传后地址
(defn upload-file-qiniu
  "实现七牛云public的上传"
  [type file]
  (let [filename (:filename file)
        bucket (:bucket qiniu-config :bucket)
        key (qiniu-upload-path type filename)
        res (qiniu/upload-bucket bucket
                                 key
                                 (:tempfile file))]
    (log/info "上传七牛云结果：" res)
    (if-not (= 200 (:status res))
      (throw (Exception. " 附件上传失败 ")))
    (str (:domain qiniu-config) key)))
