(ns <<project-ns>>.db.redis
  (:require 
   [taoensso.carmine :as car :refer (wcar)]
   [<<project-ns>>.config :refer [env]]
   [mount.core :refer [defstate]]))

(defstate server1-conn
          :start
          {:pool {}
           :spec {:host       (-> env :redis-host)
                  :port       (-> env :redis-port)
                  :password   (-> env :redis-password)
                  :timeout-ms (-> env :redis-timeout-ms)
                  :db         (-> env :redis-db)}})

(defmacro wcar* [& body] `(car/wcar server1-conn ~@body))
