(ns <<project-ns>>.product.product-sub
  (:require [re-frame.core :as rf]))

(rf/reg-sub
 :product-sub/product-table
 (fn [db]
   (get-in db [:product :product-list])))

(rf/reg-sub
 :product-sub/product-form
 (fn [db]
   (get-in db [:product :product-info])))


(rf/reg-sub
 :product/categories
 (fn [db]
   (get-in db [:product :categories])))

(rf/reg-sub
 :product/detail
 (fn [db]
   (get-in db [:product :detail] {})))

(rf/reg-sub
 :product/detail-params
 (fn [db]
   (get-in db [:product :detail :params])))

(rf/reg-sub
 :product/detail-services
 (fn [db]
   (get-in db [:product :detail :services])))

(rf/reg-sub
 :product/detail-cover-imgs
 (fn [db]
   (get-in db [:product :detail :cover-imgs] [])))

(rf/reg-sub
 :product/detail-banner-imgs
 (fn [db]
   (get-in db [:product :detail :banner-imgs] [])))

(rf/reg-sub
 :product/detail-detail-imgs
 (fn [db]
   (get-in db [:product :detail :detail-imgs] [])))

(rf/reg-sub
 :product/current-step
 (fn [db]
   (get-in db [:product :detail :current-step] {})))

(rf/reg-sub
 :product/detail-loading
 (fn [db]
   (get-in db [:product :detail :loading] {})))
