(ns <<project-ns>>.product.product-list-views
  (:require
   ["antd" :as ant]
   ["moment" :as moment]
   [kee-frame.core :as kf]
   [reagent.core :as r]
   [re-frame.core :as rf]
   [<<project-ns>>.common.utils :as utils]
   [<<project-ns>>.components.common-page :refer [main-page]]
   [<<project-ns>>.product.product-events :as events]
   [<<project-ns>>.product.product-sub :as sub]))

(def FormItem (.-Item ant/Form))

(defn word-break [text]
  [:div {:style {:word-wrap "break-word" :word-break "break-all"}} text])

(def columns [{:title "图片"
               :dataIndex "image_url"
               :render
               (fn [val]
                 (r/as-element
                  [:img {:src val :style {:width 40 :height 50}}]))}
              {:title "名称"
               :dataIndex "product_name"
               :width 100
               :render (fn [text]
                         (r/as-element [word-break text]))}
              {:title "编号"
               :dataIndex "product_no"
               :width 90
               :render (fn [text]
                         (r/as-element [word-break text]))}
              {:title "价格" :dataIndex "sales_price"}
              {:title "销量" :dataIndex "sales"}
              {:title "库存" :dataIndex "stock"}
              {:title "访问量" :dataIndex "visit"}
              {:title "标签"
               :dataIndex "sign"
               :render
               (fn [val]
                 (r/as-element
                  [:div
                   [:div {:className "row-view"} "上架"
                    [:> ant/Switch {:className "switch" :size "small"}]]
                   [:div {:className "row-view"} "新品" [:> ant/Switch {:className "switch" :size "small"}]]
                   [:div {:className "row-view"} "推荐" [:> ant/Switch {:className "switch" :size "small"}]]]))}
              {:title "排序" :dataIndex "show_type"}
              {:title "创建时间"
               :dataIndex "create_time"
               :width 108
               :render (fn [text]
                         (r/as-element [word-break (.format (.unix moment text) "YYYY/MM/DD")]))}
              {:title "操作"
               :dataIndex "action"
               :width 90
               :render
               (fn [val row index]
                 (r/as-element
                  [:div
                   [:a {:href (str "/main/product/info?id=" (:product_id (js->clj row :keywordize-keys true)))}
                    "编辑"]
                   [:> ant/Divider {:type "vertical"}]
                   [:> ant/Popconfirm
                    {:title "确定删除？"
                     :okText "确定"
                     :cancleText "取消"
                     :onConfirm #(rf/dispatch [:product/remove-product
                                               (:product_id (js->clj row :keywordize-keys true))])}
                    [:a "删除"]]]))}])

(defn product-list-page []
  (def product-table (rf/subscribe [:product-sub/product-table]))
  (fn []
    [:div
     [main-page {:title "商品列表"
                 :extra (r/as-element
                         [:a {:href "/main/product/info"}
                          [:> ant/Button
                           {:type "primary"
                            :icon "plus"
                            :style {:float "right"}} "新建"]])}
      [:> ant/Table
       {:rowKey "product_id"
        :columns columns
        :size "middle"
        :loading (or (:loading @product-table) false)
        :dataSource (if (nil? @product-table) [] (@product-table :datas))
        :pagination (let [pagination (:pagination @product-table)]
                      {:total (:total pagination)
                       :pageSize (:size pagination)
                       :current (inc (:page pagination))})
        :onChange (fn [pagination]
                    (let [{:keys [pageSize current]} (js->clj pagination :keywordize-keys true)]
                      (rf/dispatch [:product/get-product-list {:page (dec current) :size pageSize}])))}]]]))
