(ns <<project-ns>>.core
  (:require
   [kee-frame.core :as kf]
   [re-frame.core :as rf]
   ["antd" :as ant]
   [<<project-ns>>.default-db :as db]
   [<<project-ns>>.login.login-views :refer [login-page]]
   [<<project-ns>>.layout.layout-main :refer [layout-page]]))

(kf/reg-event-fx
 :core/message-error
 (fn [{:keys [db]} [response]]
   (.error ant/message "请求失败,请稍后再试")))

(kf/reg-event-fx
 :core/message-success
 (fn [{:keys [db]} [msg]]
   (.success ant/message (or msg "操作成功"))))

(rf/reg-event-fx
 :core/nav
 (fn [_ [_ route-name x]]
   (if (nil? x)
     {:navigate-to [route-name]}
     {:navigate-to [route-name x]})))

(defn root-component []
  [:div
   [kf/switch-route (fn [route] (get-in route [:data :name]))
    :login [login-page]
    :main [layout-page]
    nil [:div "404"]]])

(def route
  [["/login" :login]
   ["/main*path" :main]])

;; Initialize app
(defn ^:dev/after-load mount-components
  ([] (mount-components true))
  ([debug?]
   (rf/clear-subscription-cache!)
   (kf/start! {:debug?         (boolean debug?)
               :routes route
               :hash-routing?  true
               :initial-db     (db/init-db)
               :root-component [root-component]})))

(defn init! [debug?]
  (mount-components debug?))
