(ns {{project-ns}}.login.login-events
  (:require
   [kee-frame.core :as kf]
   [re-frame.core :as rf]))

(def user {:username "admin"
           :password "admin"})

(kf/reg-chain
 :login
 (fn [{:keys [db]} [params]]
   {:db (assoc-in db [:login :loading] true)})
 (fn [{:keys [db]} [params]]
   {:db
    (assoc-in db [:login :result] (= user params))})
 (fn [{:keys [db]}]
   (when (get-in db [:login :result])
     (rf/dispatch [:core/nav :main {:path ""} ]))
   {:db (assoc-in db [:login :loading] false)}))

(rf/reg-sub
 :login/result
 (fn [db]
   (get-in db [:login :result])))


(rf/reg-sub
 :login/loading
 (fn [db]
   (get-in db [:login :loading] false)))
