(ns {{project-ns}}.routes.services
  (:require
   [reitit.swagger :as swagger]
   [reitit.swagger-ui :as swagger-ui]
   [reitit.ring.coercion :as coercion]
   [reitit.coercion.spec :as spec-coercion]
   [reitit.ring.middleware.muuntaja :as muuntaja]
   [reitit.ring.middleware.multipart :as multipart]
   [reitit.ring.middleware.parameters :as parameters]
   [{{project-ns}}.middleware.formats :as formats]
   [{{project-ns}}.middleware.exception :as exception]
   [taoensso.carmine :as car :refer (wcar)]
   [{{project-ns}}.redis :as redis]
   [ring.util.http-response :refer :all]
   [clojure.java.io :as io]))

(defn service-routes []
  ["/api"
   {:coercion spec-coercion/coercion
    :muuntaja formats/instance
    :swagger {:id ::api}
    :middleware [;; query-params & form-params
                 parameters/parameters-middleware
                 ;; content-negotiation
                 muuntaja/format-negotiate-middleware
                 ;; encoding response body
                 muuntaja/format-response-middleware
                 ;; exception handling
                 exception/exception-middleware
                 ;; decoding request body
                 muuntaja/format-request-middleware
                 ;; coercing response bodys
                 coercion/coerce-response-middleware
                 ;; coercing request parameters
                 coercion/coerce-request-middleware
                 ;; multipart
                 multipart/multipart-middleware]}

   ;; swagger documentation
   ["" {:no-doc true
        :swagger {:info {:title "my-api"
                         :description "https://cljdoc.org/d/metosin/reitit"}}}

    ["/swagger.json"
     {:get (swagger/create-swagger-handler)}]

    ["/api-docs/*"
     {:get (swagger-ui/create-swagger-ui-handler
            {:url "/api/swagger.json"
             :config {:validator-url nil}})}]]

   ["/ping"
    {:get (constantly (ok {:message "pong"}))}]

   #_["/redis/set"
    {:get {:summary    "set redis by key"
           :parameters {:query {:key   string?
                                :value string?}}
           :handler    (fn [{{{:keys [key, value]} :query} :parameters}]
                         {:status 200
                          :body   (redis/wcar*
                                   (car/ping
                                    (car/set key value)))})}}]

   #_["/redis/get"
    {:get {:summary    "set redis by key"
           :parameters {:query {:key string?}}
           :handler    (fn [{{{:keys [key]} :query} :parameters}]
                         {:status 200
                          :body   {:data {key (redis/wcar*
                                               (car/get key))}}})}}]])
