(ns leiningen.new.hc-admin
  (:require [leiningen.new.templates :refer [multi-segment sanitize-ns renderer name-to-path ->files]]
            [leiningen.core.main :as main]
            [clojure.java.io :as io]))

(def project-relative-paths
  {:backend-path      "src/clj"
   :backend-test-path "test/clj"
   :client-path       "src/cljs"
   :client-test-path  "test/cljs"
   :resource-path     "resources"
   :cljc-path         "src/cljc"
   :db-path           "src/clj"
   :source-paths      ["src/clj"]
   :resource-paths    ["resources"]
   :now               (java.util.Date.)})

(def render (renderer "hc-admin"))

(defn hc-admin
  "FIXME: write documentation"
  [name]
  (let [data (merge
              project-relative-paths
              {:name name
               :project-ns (sanitize-ns name)
               :sanitized (name-to-path name)})
        timestamp (.format
                   (java.text.SimpleDateFormat. "yyyyMMddHHmmss")
                   (java.util.Date.))]
    (main/info "Generating fresh 'lein new' hc-admin project.")
    (->files data
             ["dev-config.edn"    (render "dev-config.edn" data)]
             [".gitignore"        (render "gitignore" data)]
             ["Procfile"          (render "Procfile" data)]
             ["project.clj"       (render "project.clj" data)]
             ["Dockerfile"        (render "Dockerfile" data)]
             ["Capstanfile"       (render "Capstanfile" data)]
             ["README.md"         (render "README.md" data)]
             ["shadow-cljs.edn"   (render "shadow-cljs.edn" data)]
             ["package.json"      (render "package.json" data)]
             ["env/prod/resources/config.edn"  (render "env/prod/resources/config.edn" data)]
             ["env/dev/resources/config.edn"  (render "env/dev/resources/config.edn" data)]
             ["env/test/resources/config.edn"  (render "env/dev/resources/config.edn" data)]

             ;; config namespaces
             
             ["env/dev/clj/{{sanitized}}/env.clj" (render "env/dev/clj/env.clj" data)]
             ["env/dev/clj/{{sanitized}}/dev_middleware.clj"  (render "env/dev/clj/dev_middleware.clj" data)]

             ["env/prod/clj/{{sanitized}}/env.clj"  (render "env/prod/clj/env.clj" data)]

             ;; core namespaces
             ["env/dev/clj/user.clj" (render "env/dev/clj/user.clj" data)]
             ["{{backend-path}}/{{sanitized}}/core.clj"  (render "src/clj/core.clj" data)]
             ["{{backend-path}}/{{sanitized}}/nrepl.clj"  (render "src/clj/nrepl.clj" data)]
             ["{{backend-path}}/{{sanitized}}/config.clj"  (render "src/clj/config.clj" data)]
             ["{{backend-path}}/{{sanitized}}/handler.clj"  (render "src/clj/handler.clj" data)]
             ["{{backend-path}}/{{sanitized}}/middleware.clj"  (render "src/clj/middleware.clj" data)]
             ["{{backend-path}}/{{sanitized}}/middleware/formats.clj"  (render "src/clj/middleware/formats.clj" data)]
             ["{{backend-path}}/{{sanitized}}/middleware/exception.clj"  (render "src/clj/middleware/exception.clj" data)]
             ["{{backend-path}}/{{sanitized}}/db/core.clj"          (render "src/clj/db/core.clj" data)]
             ["{{backend-path}}/{{sanitized}}/routes/services.clj"          (render "src/clj/routes/services.clj" data)]

             ;; migration & sql
             [(str "{{resource-path}}/migrations/" timestamp "-add-users-table.down.sql")  (render "resources/migrations/20190831145908-add-users-table.down.sql" data)]
             [(str "{{resource-path}}/migrations/" timestamp "-add-users-table.up.sql")  (render "resources/migrations/20190831145908-add-users-table.up.sql" data)]
             ["{{resource-path}}/sql/queries.sql"  (render "resources/sql/queries.sql" data)]

             ["{{resource-path}}/public/favicon.ico"  (render "resources/public/favicon.ico" data)]
             ["{{resource-path}}/public/index.html"  (render "resources/public/index.html" data)]
             ["{{resource-path}}/public/img/warning_clojure.png"  (render "resources/public/img/warning_clojure.png" data)]

             ;; public resources, example URL: /css/screen.css
             ["{{resource-path}}/public/css/layout.css"  (render "resources/public/css/layout.css" data)]
             ["{{resource-path}}/public/css/login.css"  (render "resources/public/css/login.css" data)]
             ["{{resource-path}}/public/css/product.css"  (render "resources/public/css/product.css" data)]
             "{{resource-path}}/public/js"

             ;; tests
             ["{{backend-test-path}}/{{sanitized}}/test/handler.clj" (render "test/clj/handler.clj" data)]
             ["{{backend-test-path}}/{{sanitized}}/test/db/core.clj"  (render "test/clj/db/core.clj" data)]

             ;; cljs
             ["env/dev/cljs/{{sanitized}}/app.cljs"  (render "env/dev/cljs/app.cljs" data)]
             ["env/prod/clj/{{sanitized}}/app.cljs"  (render "env/prod/cljs/app.cljs" data)]
             ["{{client-path}}/{{sanitized}}/config.cljs"  (render "src/cljs/config.cljs" data)]
             ["{{client-path}}/{{sanitized}}/core.cljs"  (render "src/cljs/core.cljs" data)]
             ["{{client-path}}/{{sanitized}}/default_db.cljs"  (render "src/cljs/default_db.cljs" data)]
             ["{{client-path}}/{{sanitized}}/index.cljs"  (render "src/cljs/index.cljs" data)]
             ["{{client-path}}/{{sanitized}}/router.cljs"  (render "src/cljs/router.cljs" data)]
             
             ;;admin system
             ["{{client-path}}/{{sanitized}}/login/login_views.cljs"   (render "src/cljs/login/login_views.cljs" data)]
             ["{{client-path}}/{{sanitized}}/login/login_events.cljs"  (render "src/cljs/login/login_events.cljs" data)]
             ;;layout-5
             ["{{client-path}}/{{sanitized}}/layout/layout_views.cljs"  (render "src/cljs/layout/layout_views.cljs" data)]
             ["{{client-path}}/{{sanitized}}/layout/layout_events.cljs"  (render "src/cljs/layout/layout_events.cljs" data)]
             ["{{client-path}}/{{sanitized}}/layout/layout_main.cljs"  (render "src/cljs/layout/layout_main.cljs" data)]
             ["{{client-path}}/{{sanitized}}/layout/global_footer.cljs"  (render "src/cljs/layout/global_footer.cljs" data)]
             ["{{client-path}}/{{sanitized}}/layout/side_menu.cljs"  (render "src/cljs/layout/side_menu.cljs" data)]
             ;;common-3
             ["{{client-path}}/{{sanitized}}/common/utils.cljs"  (render "src/cljs/common/utils.cljs" data)]
             ["{{client-path}}/{{sanitized}}/common/route_mapping.cljs"  (render "src/cljs/common/route_mapping.cljs" data)]
             ["{{client-path}}/{{sanitized}}/common/storage.cljs"  (render "src/cljs/common/storage.cljs" data)]
             ;;components-2
             ["{{client-path}}/{{sanitized}}/components/common_page.cljs"  (render "src/cljs/components/common_page.cljs" data)]
             ["{{client-path}}/{{sanitized}}/components/upload.cljs"  (render "src/cljs/components/upload.cljs" data)]
             ;;product demo
             ["{{client-path}}/{{sanitized}}/product/product_custom_views.cljs"  (render "src/cljs/product/product_custom_views.cljs" data)]
             ["{{client-path}}/{{sanitized}}/product/product_data_convert.cljs"  (render "src/cljs/product/product_data_convert.cljs" data)]
             ["{{client-path}}/{{sanitized}}/product/product_events.cljs"  (render "src/cljs/product/product_events.cljs" data)]
             ["{{client-path}}/{{sanitized}}/product/product_info_views.cljs"  (render "src/cljs/product/product_info_views.cljs" data)]
             ["{{client-path}}/{{sanitized}}/product/product_init_db.cljs"  (render "src/cljs/product/product_init_db.cljs" data)]
             ["{{client-path}}/{{sanitized}}/product/product_list_views.cljs"  (render "src/cljs/product/product_list_views.cljs" data)]
             ["{{client-path}}/{{sanitized}}/product/product_sub.cljs"  (render "src/cljs/product/product_sub.cljs" data)]
             ;;system-user demo
             ["{{client-path}}/{{sanitized}}/sys/system_user_views.cljs"  (render "src/cljs/product/sys_user_views.cljs" data)]
             ["{{client-path}}/{{sanitized}}/system/sys_user_events.cljs"  (render "src/cljs/product/sys_user_events.cljs" data)]
             ["{{client-path}}/{{sanitized}}/system/sys_user_sub.cljs"  (render "src/cljs/product/sys_user_sub.cljs" data)]
             ["{{client-path}}/{{sanitized}}/system/sys_user_main.cljs"  (render "src/cljs/product/sys_user_main.cljs" data)]

             )))
