(ns {{project-ns}}.product.product-data-convert
  (:require
   ["uuid" :as uid]
   [clojure.string :as string]))

(defn- boolean->str [b]
  (if b "1" "0"))

(defn- map-key-value [data]
  (map
   #(select-keys % [:key :value])
   (filter (fn [{:keys [key value]}] (and (not (string/blank? key)) (not (string/blank? value))))  data)))

(defn product-db->request-params [db]
  (let [{:keys [product-name product-no category-ids
                sale-price vip-price suit-type
                cover-imgs banner-imgs detail-imgs
                params services product-intro remark
                recommend? online?]}
        (get-in db [:product :detail])]
    {:product {:product_type "1"
               :category_id (or (last category-ids) "")
               :recommend_type (boolean->str recommend?)
               :custom_type "2"
               :product_name product-name
               :vip_price vip-price
               :product_no product-no
               :product_intro product-intro
               :show_type "0"
               :sales_price sale-price
               :suit_type suit-type
               :remark (or remark "")
               :image_url (or (:url (first cover-imgs) ""))
               :product_status (boolean->str online?)}
     :params (map-key-value params)
     :services (map-key-value services)
     :banner_images (map-indexed
                     (fn [idx itm] {:image_url (:url itm) :show_order idx})
                     banner-imgs)
     :detail_images (map-indexed (fn [idx itm] {:image_url (:url itm) :show_order idx})
                                 detail-imgs)
     :suit_items []
     :custom_fabrics []
     :custom_printing {:position []
                       :printing []}
     :custom_embroidery {:position []
                         :font []
                         :color []}
     :custom_craftworks []
     :colors []
     :default_data {:fabric []
                    :craftworks []}}))

(defn- str->boolean [s]
  (= "1" s))

(defn- db-images [imgs]  
  (map (fn [item] {:url (:image_url item)
                  :uid (.v1 uid)
                  :status "done"}) imgs))

(defn product-dtail->db [detail]
  {:current-step 0
   :loading false
   :product-id (:product_id detail)
   :product-name (:product_name detail)
   :product-no (:product_no detail)
   :category-ids [(:category_id detail)]
   :suit-type (:suit_type detail)
   :sale-price (:sales_price detail)
   :vip-price (:vip_price detail)
   :params (map #(assoc % :id (.v1 uid)) (:params detail))
   :services (map #(assoc % :id (.v1 uid)) (:services detail))
   :product-intro (:product_intro detail)
   :remark (:remark detail)
   :cover-imgs  (if (string/blank? (:image_url detail))
                  []
                  [{:url (:image_url detail)
                    :status "done"
                    :uid -1}])
   :banner-imgs (db-images (:banner_images detail))
   :detail-imgs (db-images (:detail_images detail))
   :online? (str->boolean (:product_status detail))
   :new? true
   :recommend? (str->boolean (:recommend_type detail))})
