(ns {{project-ns}}.layout.layout-main
  (:require
   [re-frame.core :as rf]
   [{{project-ns}}.router :refer [routes]]
   [{{project-ns}}.common.route-mapping :refer [main-switch-route]]
   [{{project-ns}}.layout.side-menu :refer [create-side-menus]]
   [{{project-ns}}.layout.layout-events :as layout-events]
   [{{project-ns}}.layout.layout-views :refer [basic-layout]]))

(def breadcrumbs (rf/subscribe [:layout/breadcrumbs]))

(defn layout-page []
  (fn []
    (let [side-menus (create-side-menus routes)
          switch-route (main-switch-route routes)]
      [:div
       [basic-layout side-menus @breadcrumbs switch-route]])))
