(ns {{project-ns}}.product.product-events
  (:require
   ["uuid" :as uid]
   [ajax.core :as http]
   [clojure.string :as string]
   [kee-frame.core :as kf]
   [re-frame.core :as rf]
   [{{project-ns}}.product.product-init-db :refer [product-db]]
   [{{project-ns}}.config :refer [domain]]
   [{{project-ns}}.product.product-data-convert :as convert]))

(def product-list-url (str domain "/admin/product/list"))
(def product-category-url (str domain  "/admin/product/categorys"))
(def default-query {:page 0 :size 10})

(def token "eyJhbGciOiJIUzI1NiJ9.eyJleHAiOjE1OTg1NzczODksInR5cGUiOiJhY2Nlc3MtdG9rZW4iLCJ1c2VyIjp7InVzZXJfbmFtZSI6ImFkbWluIiwiY29tcGFueV9pZCI6IjEiLCJhcHBfaWQiOiIxIn0sImlhdCI6MTU2NzA0MTM4OX0.IdQMZiRkcDnmo82bUv754zV3bpthNSL_DIzu438GmmE")

(defn xhrio [method uri params]
  {:method method
   :uri uri
   :params params
   :headers {:authorization token}
   :timeout 10000
   :format          (http/json-request-format)
   :response-format (http/json-response-format {:keywords? true})
   :on-failure [:core/message-error]})

(kf/reg-controller
 :product/product-list-controller
 {:params (fn [route]
            (when (-> route :path-params :path (= "/product/list")) true))
  :start (fn []
           [:product/get-product-list default-query])})

(kf/reg-controller
 :product/product-add-controller
 {:params (fn [route]
            (= "/product/info" (get-in route [:path-params :path])))
  :start (fn []
           [:product/init-detail])})

(kf/reg-controller
 :product/product-edit-controller
 {:params (fn [route]
            (let [path (get-in route [:path-params :path])
                  query (get route :query-string)]
              (when (and (= path "/product/info") (re-find #"id=\w+" (or query "")))
                (second (string/split query "=")))))
  :start (fn [_ id]
           [:product/fetch-product-detail id])})

(kf/reg-chain
 :product/get-product-list
 (fn [{:keys [db]} [query]]
   {:db (assoc-in db [:product :product-list :loading] true)
    :http-xhrio (xhrio
                 :get
                 product-list-url
                 (merge default-query (or query default-query)))})
 
 (fn [{:keys [db]} [query {:keys [data]}]]
   {:db (assoc-in db [:product :product-list]
                  {:datas (:list data)
                   :pagination (assoc query :total (:total data))
                   :loading false})}))

(defn recurse-category-tree [{:keys [sublist category_id category_name]}]
  (let [item {:value category_id
              :label category_name}]
    (if (and sublist (pos? (count sublist)))
      (assoc item :children (mapv recurse-category-tree sublist))
      (identity item))))

(kf/reg-chain
 :product/init-detail
 (fn [{:keys [db]}]
   {:db (assoc-in db [:product :detail]
                  (get-in product-db [:product :detail] {}))})
 (fn [{:keys [db]}]
   {:http-xhrio (xhrio :get product-category-url nil)})
 (fn [{:keys [db]} [{:keys [data]}]]
   {:db (assoc-in db [:product :categories] (mapv recurse-category-tree data))}))

(kf/reg-chain
 :product/fetch-product-detail
 (fn [{:keys [db]} [product-id]]
   {:db (assoc-in db [:product :detail :loading] true)})
 (fn [{:keys [db]} [product-id]]
   (let [url (str domain "/admin/product/detail/" product-id)]
     {:http-xhrio (xhrio :get url {})}))
 (fn [{:keys [db]} [_ {:keys [data]}]]
   {:db (assoc-in db [:product :detail] (convert/product-dtail->db data))}))


(kf/reg-event-db
 :product/add-detail-param
 (fn [db [param]]
   (update-in db [:product :detail :params]
              #(into [] (concat % [(assoc param :id (.v1 uid))])))))

(kf/reg-event-db
 :product/remove-detail-params
 (fn [db [param]]
   (update-in db [:product :detail :params]
              #(remove (fn [itm] (= (:id param) (:id itm))) %))))

(kf/reg-event-db
 :product/update-detail-params
 (fn [db [param]]
   (update-in db [:product :detail :params]
              #(map (fn [itm] (if (= (:id itm) (:id param)) param itm)) %))))

(kf/reg-event-db
 :product/add-detail-service
 (fn [db [param]]
   (update-in db [:product :detail :services]
              #(into [] (concat % [(assoc param :id (.v1 uid))])))))

(kf/reg-event-db
 :product/remove-detail-service
 (fn [db [param]]
   (update-in db [:product :detail :services]
              #(remove (fn [itm] (= (:id param) (:id itm))) %))))

(kf/reg-event-db
 :product/update-detail-service
 (fn [db [param]]
   (update-in db [:product :detail :services]
              #(map (fn [itm] (if (= (:id itm) (:id param)) param itm)) %))))

(defn upload-imgs [imgs]
  (map
   (fn [img]
     (let [url (get-in img [:response :data :file_url])]
       (if url (assoc img :url url) img)))
   (filter #(not= (:status %) "removed") imgs)))

(kf/reg-event-db
 :product/set-cover-imgs
 (fn [db [cover-imgs]]
   (assoc-in db [:product :detail :cover-imgs]
             (upload-imgs cover-imgs))))

(kf/reg-event-db
 :product/set-banner-imgs
 (fn [db [banner-imgs]]
   (assoc-in db [:product :detail :banner-imgs]
             (upload-imgs banner-imgs))))

(kf/reg-event-db
 :product/set-detail-imgs
 (fn [db [detail-imgs]]
   (assoc-in db [:product :detail :detail-imgs]
             (upload-imgs detail-imgs))))

(kf/reg-event-db
 :product/set-current-step
 (fn [db [current-step]]
   (assoc-in db [:product :detail :current-step] current-step)))

(kf/reg-event-db
 :product/update-prodcut-detail
 (fn [db [prodcut-detail]]
   (assoc-in db [:product :detail]
             (merge (get-in db [:product :detail] {}) prodcut-detail))))

(defn- product-detail-id [db]
  (get-in db [:product :detail :product-id]))

(kf/reg-chain
 :product/update-product
 (fn [{:keys [db]} [data]]
   {:db (update-in db [:product :detail] #(into {} [% data {:submit-loading true}]))})
 (fn [{:keys [db]}]
   (if-let [product-id (product-detail-id db)]
     (let [url (str domain "/admin/product/update/" product-id)]
       {:http-xhrio (xhrio :post url (convert/product-db->request-params db))})
     (let [url (str domain "/admin/product/add")]
       {:http-xhrio (xhrio :post url (convert/product-db->request-params db))})))
 (fn [{:keys [db]}]
   (if (product-detail-id db)
     {:db (update-in db [:product :detail] #(assoc % :current-step 0 :submit-loading false))
      :dispatch [:core/message-success "更新成功"]}
     {:db (assoc-in db [:product :detail] (get-in product-db [:product :detail] {}))
      :dispatch [:core/message-success "添加成功"]})))

(kf/reg-chain
 :product/remove-product
 (fn [{:keys [db]} [id]]
   (let [url (str domain "/admin/product/remove/" id)]
     {:http-xhrio (xhrio :post url nil)
      :dispatch [:core/message-success "删除成功"]}))
 (fn [_ _]
   {:dispatch [:product/get-product-list default-query]}))
