(ns {{project-ns}}.product.product-custom-views
  (:require
   [kee-frame.core :as kf]
   [reagent.core :as r]
   [re-frame.core :as rf]
   ["antd" :as ant]
   [{{project-ns}}.common.utils :as utils]))

(def FormItem (.-Item ant/Form))
(def RadioGroup (.-Group ant/Radio))
(def SelectOption (.-Option ant/Select))

(def itemList [1, 2, 3, 4, 5, 6, 7, 8, 9, 10])
(def isFabric (r/atom 1))

(defn create-item []
  (fn []
    [:div {:class-name "custom-item-wrapper"}
     (for [item itemList]
       [:div {:class-name "custom-item"}
        [:img {:src "https://img.alicdn.com/imgextra/https://img.alicdn.com/imgextra/i2/730160956/O1CN011Ivt6epW1RqgutN_!!730160956.jpg_430x430q90.jpg"
               :class-name "custom-item-img"
               :sizingMethod "scale"}]
        [:span {:class-name "custom-item-font"} item]
        [:div {:class-name "custom-item-price"} "￥200.00"]
        [:> ant/Switch {:style {:margin-top 10}
                        :checkedChildren "默认"}]])]))

;; 面料定制
(defn create-fabric [this]
  (fn []
    [:> ant/Card {:bordered false :title "面料定制"}
     [:> ant/Row
      [:> FormItem {:label "是否定制:" :labelCol {:span 2} :wrapperCol {:span 15}}
       (utils/decorate-field
        this "online"
        [:div {:style {:margin-top "9px"}}
         [:> RadioGroup {:value @isFabric
                         :on-change (fn [v]
                                      (reset! isFabric v.target.value))}
          [:> ant/Radio {:value 1} "是"]
          [:> ant/Radio {:value 0} "否"]]])]]
     (when (= @isFabric 1)
       [:> ant/Row
        [:> FormItem {:label "面料:" :labelCol {:span 2} :wrapperCol {:span 15}}
         (utils/decorate-field
          this "online"
          [:div
           [:> ant/Select
            {:mode "multiple"
             :style {:width 200}
             :dropdownStyle {:maxHeight 400 :overflow "auto"}
             :placeholder "请选择所属品类"}
            [:> SelectOption {:value 1 :key 1} "aaa"]
            [:> SelectOption {:value 2 :key 2} "bbb"]
            [:> SelectOption {:value 3 :key 3} "ccc"]]
           [create-item]])]])]))

(defn create-form []
  (fn [props]
    (let [this (utils/get-form)]
      [:> ant/Form
       [create-fabric this]])))

(defn product-custom-page []
  (fn []
    [:div
     [:> ant/PageHeader
      {:title "填写商品促销"}]
     [:link {:rel "stylesheet" :href "/css/product.css"}]

     [:> ant/Card
      (utils/create-form create-form)
      [:> ant/Row
       [:> ant/Col {:span 4 :offset 2}
        [:> ant/Button
         {:on-click
          (fn []
            (rf/dispatch [:core/nav :product-promotion]))} "上一步，填写商品促销"]]
       [:> ant/Col {:span 4}
        [:> ant/Button
         {:type "primary" :style {:margin-left 20}} "完成，提交商品"]]]]]))
