(ns {{project-ns}}.router
  (:require
   [{{project-ns}}.index :refer [index-page]]
   [{{project-ns}}.product.product-list-views :refer [product-list-page]]
   [{{project-ns}}.product.product-info-views :refer [product-info-page]]
   [{{project-ns}}.product.product-custom-views :refer [product-custom-page]]
   [{{project-ns}}.banner.banner-list-page-views :refer [banner-list-page]]
   [{{project-ns}}.system.sys-user-main :refer [sys-user-page]]))

(def routes
  [["" {:name :home
        :title "首页"
        :icon "home"
        :page index-page}]
   ["/product" {:name :product :title "商品管理" :icon "shop"}
    ["/list" {:name :product-list
              :title "商品列表"
              :page product-list-page}]
    ["/info" {:name :product-info
              :title "填写商品信息"
              :show false
              :page product-info-page}]
    ["/custom" {:name :product-custom
                :title "填写商品定制"
                :show false
                :page product-custom-page}]]
   ["/index" {:name :index :title "首页管理" :icon "home"}
    ["/banner" {:name :banner-list
                :title "轮播图列表"
                :page banner-list-page}]]
   ["/system" {:name :system :title "系统管理" :icon "setting"}
    ["/user" {:name :system-user
              :title "系统用户"
              :page sys-user-page}]]])
