(ns leiningen.new.hc-admin
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "hc-admin"))

(defn hc-admin
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :namespace (multi-segment (sanitize-ns name))
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' hc-admin project.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["README.md" (render "README.md" data)]
             [".gitignore" (render "gitignore" data)]
             ["src/cljs/{{sanitized}}/ajax.cljs" (render "ajax.cljs" data)]
             ["src/cljs/{{sanitized}}/core.cljs" (render "core.cljs" data)]
             ["src/cljs/{{sanitized}}/view.cljs" (render "view.cljs" data)]
             ["src/cljs/{{sanitized}}/routing.cljs" (render "routing.cljs" data)]
             ["package.json" (render "package.json" data)]
             ["shadow-cljs.edn" (render "shadow-cljs.edn" data)])))
