(ns leiningen.new.hc-admin
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "hc-admin"))

(defn hc-admin
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :namespace (multi-segment (sanitize-ns name))
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' hc-admin-antd project.")
    (->files data
             ["README.md" (render "README.md" data)]
             [".gitignore" (render "gitignore" data)]
             ["project.clj" (render "project.clj" data)]
             ["src/clj/{{sanitized}}/config.clj" (render "config.clj" data)]
             ["src/clj/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["src/clj/{{sanitized}}/handler.clj" (render "handler.clj" data)]
             ["src/clj/{{sanitized}}/layout.clj" (render "layout.clj" data)]
             ["src/clj/{{sanitized}}/middleware.clj" (render "middleware.clj" data)]
             ["src/clj/{{sanitized}}/nrepl.clj" (render "nrepl.clj" data)]
             ["src/clj/routes/{{sanitized}}/home.clj" (render "home.clj" data)]
             ["src/clj/middleware/{{sanitized}}/formats.clj" (render "formats.clj" data)]
             ["src/cljc/{{sanitized}}/validation.clj" (render "validation.cljc" data)]
             ["src/cljs/{{sanitized}}/ajax.clj" (render "ajax.cljs" data)]
             ["src/cljs/{{sanitized}}/view.clj" (render "view.cljs" data)]
             ["src/cljs/{{sanitized}}/core.clj" (render "core.cljs" data)]
             ["src/cljs/{{sanitized}}/routing.cljs" (render "routing.clj" data)]
             ["resources/html/home.html" (render "home.html" data)]
             )))
