(ns hara.tool
  (:require [hara.module :as module]))

(defn- inject-reflectors
  []
  (module/link
   {:ns 'clojure.core}
   (hara.tool.reflect                 .%
                                      .%>
                                      .?
                                      .?*
                                      .?>
                                      .*
                                      .*>
                                      .&)))

(defn- inject-tools
  []
  (create-ns '.)
  (module/link
   {:ns '.}
   (hara.lib.aether         pull push)
   (hara.io.project         project)
   (hara.test               run
                            run-errored)
   (hara.tool.compile.java  javac)
   (hara.code               incomplete
                            import
                            scaffold
                            arrange
                            purge
                            orphaned
                            missing
                            todos
                            in-order?)
   (hara.module.namespace   reset
                            clear
                            clear-aliases
                            clear-interns
                            clear-refers)))

(def +inject-vars+ (do (inject-reflectors)
                       (inject-tools)
                       (module/resolve-links)
                       true))

(defn dev
  "startup function only for :dev"
  {:added "3.0" :shadow/requires-server true}
  [])
