(ns hara.time.data.coerce
  (:require [hara.protocol.string :as protocol.string]
            [hara.protocol.time :as protocol.time]
            [hara.time.data.common :as common]
            [hara.time.data.map :as map]))

(defn coerce-zone
  "coercion of one zone object to another
   (-> (coerce-zone \"Asia/Kolkata\" {:type TimeZone})
       (string/-to-string))
   => \"Asia/Kolkata\"
 
   (-> (coerce-zone nil {:type TimeZone})
       (string/-to-string))
   => (-> (TimeZone/getDefault)
          (string/-to-string))"
  {:added "3.0"}
  [value {:keys [type] :as opts}]
  (cond (nil? value)
        (protocol.string/-from-string (common/default-timezone)
                                      type
                                      opts)

        (instance? type value)
        value

        (string? value)
        (protocol.string/-from-string value type opts)

        :else
        (->  value
             (protocol.string/-to-string)
             (protocol.string/-from-string type opts))))

(defn coerce-instant
  "coercion of one instant object to another
   (-> ^Calendar (coerce-instant 0 {:type Calendar})
       (.getTime)
       (.getTime))
   => 0"
  {:added "3.0"}
  [value {:keys [type] :as opts}]
  (cond (instance? type value)
        value

        (or (= type Long) (nil? type))
        (protocol.time/-to-long value)

        (instance? Long value)
        (protocol.time/-from-long value opts)

        (instance? clojure.lang.APersistentMap value)
        (map/from-map value opts)

        :else
        (-> value
            (protocol.time/-to-long)
            (protocol.time/-from-long opts))))
