(ns hara.publish.prepare
  (:require [hara.publish.collect.api :as collect.api]
            [hara.publish.collect.base :as collect.base]
            [hara.publish.collect.reference :as collect.reference]
            [hara.publish.link.anchor :as link.anchor]
            [hara.publish.link.api :as link.api]
            [hara.publish.link.chapter :as link.chapter]
            [hara.publish.link.namespace :as link.namespace]
            [hara.publish.link.number :as link.number]
            [hara.publish.link.reference :as link.reference]
            [hara.publish.link.stencil :as link.stencil]
            [hara.publish.link.tag :as link.tag]
            [hara.publish.link.test :as link.test]
            [hara.publish.parse :as parse]))

(defn prepare
  "processes a single meta to generate an interim structure
   (let [project (publish/make-project)
         lookup  (executive/all-pages project)]
     (prepare 'hara/index {} lookup project))
   => (contains-in {:articles {\"index\" map?},
                    :global map?
                    :namespaces map?
                    :anchors-lu {\"index\" map?},
                    :anchors {\"index\" map?}})"
  {:added "3.0"}
  [key params lookup {:keys [root] :as project}]
  (let [{:keys [name input] :as meta} (lookup key)
        elements (if input (parse/parse-file input {:root root}) [])]
    (-> meta
        (assoc :project project)
        (assoc-in [:articles name :elements] elements)
        (assoc-in [:articles name :meta] meta)
        (collect.base/collect-global-metas name)
        (collect.base/collect-article-metas name)
        (collect.base/collect-namespaces name)
        (collect.reference/collect-references name)
        (collect.api/collect-apis name)
        (collect.base/collect-tags name)
        (collect.base/collect-citations name)
        (link.namespace/link-namespaces name)
        (link.reference/link-references name)
        (link.api/link-apis name)
        (link.chapter/link-chapters name)
        (link.test/link-tests name)
        (link.number/link-numbers name)
        (link.tag/link-tags name)
        (link.anchor/link-anchors-lu name)
        (link.anchor/link-anchors name)
        (link.stencil/link-stencil name))))
