(ns hara.publish.link.stencil
  (:require [hara.string :as string]
            [hara.string.mustache :as mustache]))

(def full-citation-pattern
  (string/joinl ["\\[\\["
                "([^/^\\.^\\{^\\}^\\[^\\]]+)"
                "/"
                "([^/^\\.^\\{^\\}^\\[^\\]]+)"
                "\\]\\]"]))

(def short-citation-pattern
  (string/joinl ["\\[\\["
                "([^/^\\.^\\{^\\}^\\[^\\]]+)"
                "\\]\\]"]))

(def full-pattern
  (string/joinl ["\\{\\{"
                "([^/^\\.^\\{^\\}]+)"
                "/"
                "([^/^\\.^\\{^\\}]+)"
                "\\}\\}"]))

(def short-pattern
  (string/joinl ["\\{\\{"
                "([^/^\\.^\\{^\\}]+)"
                "\\}\\}"]))

(defn transform-stencil
  "creates a link to the given tags"
  {:added "3.0"}
  [string name tags]
  (-> string
      (.replaceAll full-citation-pattern "[{{$1/$2}}]($1.html#$2)")
      (.replaceAll short-citation-pattern "[{{$1}}](#$1)")
      (.replaceAll full-pattern  "{{$1.$2.number}}")
      (.replaceAll short-pattern (str "{{" name ".$1.number}}"))
      (mustache/render tags)))

(defn link-stencil
  "creates links to all the other documents in the project"
  {:added "3.0"}
  [interim name]
  (let [anchors (assoc (:anchors interim)
                       :PROJECT (:project interim)
                       :DOCUMENT (get-in interim [:articles name :meta]))]
    (update-in interim [:articles name :elements]
               (fn [elements]
                 (->> elements
                      (map (fn [element]
                             (cond (= :paragraph (:type element))
                                   (update-in element [:text]
                                              transform-stencil name anchors)

                                   (:stencil element)
                                   (update-in element [:code]
                                              transform-stencil name anchors)

                                   :else element))))))))
