(ns hara.protocol.table)

(defprotocol ITable
  (-put      [store table m opts] [store m])
  (-cas      [store table old new opts])
  (-set      [store table m opts])
  (-delete   [store table id otps])
  (-update   [store table id f args opts])
  (-clear    [store] [store table opts])
  (-bulk     [store m opts])
  (-db       [store] [store time opts]))

(defprotocol IQuery
  (-get      [store table id opts])
  (-get-in   [store table ids opts])
  (-keys     [store] [store table opts])
  (-count    [store table opts] [store table query opts])
  (-select   [store table opts] [store table query opts]))

(defprotocol ISchema
  (-install-schema    [db schema])
  (-uninstall-schema  [db schema]))

(defmulti -create-datastore
  "constructs a datastore"
  {:added "1.0"}
  :type)
