(ns hara.protocol.cache)

(def ^:dynamic *bulk* false)

(defprotocol ICache
  (-set      [cache key value]
             [cache key value expiry])
  (-get      [cache key])
  (-has?     [cache key])
  (-count    [cache])
  (-batch    [cache add-values add-expiry remove-vec])
  (-delete   [cache keys])
  (-clear    [cache])
  (-all      [cache])
  (-keys     [cache] [cache pattern])
  (-touch    [cache key expiry])
  (-expired? [cache key])
  (-expiry   [cache key])
  (-export   [cache key])
  (-import   [cache key data]))

(defprotocol ICacheExtend
  (-mget     [cache keys])
  (-mset     [cache args])
  (-bulk     [cache thunk])
  (-transact [cache thunk])
  (-notify   [cache name pattern f])
  (-denotify [cache name]))

(defprotocol ICacheList
  (-lindex   [cache key index])
  (-llen     [cache key])
  (-lpop     [cache key])
  (-lpush    [cache key elements])
  (-lrange   [cache key start stop])
  (-lrem     [cache key count value])
  (-lset     [cache key index element])
  (-ltrim    [cache key start stop])
  (-rpop     [cache key])
  (-rpush    [cache key elements]))

(defprotocol ICacheHash
  (-hdel     [cache key fields])
  (-hexists  [cache key field])
  (-hget     [cache key value])
  (-hmget    [cache key fields])
  (-hgetall  [cache key])
  (-hkeys    [cache key])
  (-hlen     [cache key])
  (-hset     [cache key args])
  (-hvals    [cache key]))

(defprotocol ICacheSortedSet
  (-zadd     [cache key args])
  (-zcard    [cache key])
  (-zcount   [cache key min max])
  (-zpopmin  [cache key count])
  (-zpopmax  [cache key count])
  (-zrange   [cache key start stop])
  (-zrangebyscore  [cache key min max])
  (-zrank    [cache key member])
  (-zrem     [cache key members])
  (-zremrangebyscore [cache key min max])
  (-zrevrange [cache key start stop])
  (-zrevrank  [cache key member])
  (-zscore    [cache key member]))

(defmulti -create
  "creates a cache for use with components"
  {:added "3.0"}
  :type)
