(ns hara.platform.table.base
  (:require [hara.platform.table.atom :as atom]
            [hara.protocol.table :as protocol.table]))

(defrecord MockStore [state]

  Object
  (toString [store]
    (str "#store.mock " (vec (protocol.table/-keys state))))

  protocol.table/ITable
  (-put [store table m opts] (atom/put-atom state table m) store)
  (-put [store m] (atom/put-bulk-atom state m) store)
  (-set [store table m opts] (atom/set-atom state table m) store)
  (-cas [store table old new opts] (atom/cas-atom state table old new) store)
  (-delete [store table id opts] (atom/delete-atom state table id) store)
  (-update [store table id f args opts] (atom/update-atom state table id f args) store)
  (-clear [store] (atom/clear-atom state) store)
  (-clear [store table opts] (atom/clear-atom state table) store)
  (-bulk  [store m opts] (atom/bulk-atom state m) store)
  (-db [store] store)
  (-db [store time opts] store)

  protocol.table/IQuery
  (-get [store table id opts] (atom/get-atom state table id))
  (-get-in [store table ids opts] (atom/get-in-atom state table ids))
  (-keys [store] (atom/keys-atom state))
  (-keys [store table opts] (atom/keys-atom state table))
  (-select [store table opts] (atom/list-atom state table))
  (-select [store table query opts] (atom/select-atom state table query)))

(defmethod print-method MockStore
  [v ^java.io.Writer w]
  (.write w (str v)))

(defmethod protocol.table/-create-datastore :mock
  [m]
  (map->MockStore (assoc m :state (atom {}))))
