(ns hara.log.common)

(def ^:dynamic *level* :info)

(def ^:dynamic *context* nil)

(def ^:dynamic *static* false)

(def ^:dynamic *logger* nil)

(def +levels+ (merge (zipmap [:debug :code :status :info :todo :warn :error :fatal]
                             (range))
                     {:spy 0 :trace 0 :note 0}))

(defn set-static!
  "sets the global static variable"
  {:added "3.0"}
  [bool]
  (alter-var-root #'*static* (fn [_] bool)))

(defn set-level!
  "sets the global level variable"
  {:added "3.0"}
  [status]
  (alter-var-root #'*level* (fn [_] status)))

(defn set-context!
  "sets the global level variable"
  {:added "3.0"}
  [context]
  (alter-var-root #'*context* (fn [_] context)))

(defn set-logger!
  "sets the global logger"
  {:added "3.0"}
  [logger]
  (alter-var-root #'*logger* (fn [_] logger)))

(defn put-logger!
  "updates the global logger"
  {:added "3.0"}
  ([{:keys [global namespace function filter] :as data}]
   (put-logger! *logger* data))
  ([{:keys [instance] :as logger} data]
   (swap! instance merge data)
   logger))
