(ns hara.platform.eft
  (:require [hara.protocol.eft :as protocol.eft]
            [hara.platform.eft.mock :as mock]
            [hara.core.component :as component]))

(defn submit
  "submits transaction to eft
 
   (binding [mock/*bank* (bank/bank {:type :mock :accounts [{:id \"A\" :balances {\"USD\" 1000}}]})]
     (-> (create {:type :mock})
         (submit {:type :deposit :id \"A\" :currency \"USD\" :amount 500})))
   => (contains-in {:status :success,
                    :data {:type :fund.deposit,
                           :receipt string?
                           :time number?
                           :amount 500}})"
  {:added "3.0"}
  ([fund {:keys [type id currency amount] :as data}]
   (protocol.eft/-submit fund data)))

(defn status
  "checks the status of a transaction
 
   (binding [mock/*bank* (bank/bank {:type :mock :accounts [{:id \"A\" :balances {\"USD\" 1000}}]})]
     (-> (create {:type :mock})
        (status (-> @(:runtime mock/*bank*) :log first :tx)))
     => :processed)"
  {:added "3.0"}
  ([fund receipt]
   (protocol.eft/-status fund receipt)))

(defn detail
  "gets the details of a transaction
   
   (binding [mock/*bank* (bank/bank {:type :mock :accounts [{:id \"A\" :balances {\"USD\" 1000}}]})]
     (-> (create {:type :mock})
         (detail (-> @(:runtime mock/*bank*) :log first :tx))))
   => (contains {:op :add-account, :id \"A\", :name \"\", :balances {\"USD\" 1000}})"
  {:added "3.0"}
  ([fund receipt]
   (protocol.eft/-detail fund receipt)))

(defn eft?
  "checks if object is an eft
 
   (eft? (create {:type :mock}))
   => true"
  {:added "3.0"}
  ([obj]
   (satisfies? protocol.eft/IFund obj)))

(defn create
  "creates an eft
 
   (create {:type :mock})
   => eft?"
  {:added "3.0"}
  ([m]
   (protocol.eft/-create m)))

(defn eft
  "creates a componentized  eft
 
   (eft {:type :mock})
    => eft?"
  {:added "3.0"}
  ([m]
   (-> (create m)
       (component/start))))


(comment
  
  
  (submit (eft {:type :mock})
          {:type :deposit
           :id "test@test.com"
           :currency "STATS"
           :amount 10})
  {:status :success, :data {:type :fund.deposit, :receipt "1if12oo2xf0hc", :time 153550199622138, :currency "STATS", :amount 10, :id "test@test.com"}}

  (status (eft {:type :mock}) "1if12oo2xf0hc")
  :processed

  (detail (eft {:type :mock}) "1if12oo2xf0hc")
  {:op :adjust-account, :id "test@test.com", :tx "1if12oo2xf0hc", :currency "STATS", :amount 10, :time 153550199622138, :old 0, :new 10}

  (submit (eft {:type :mock})
          {:type :withdraw
           :id "test@test.com"
           :currency "STATS"
           :amount 10})
  {:status :success, :data {:type :fund.withdraw, :receipt "qxiag2ys9dte", :time 153635268227023, :currency "STATS", :amount 10, :id "test@test.com"}}

  (detail (eft {:type :mock}) "qxiag2ys9dte")
  {:op :adjust-account, :id "test@test.com", :tx "qxiag2ys9dte", :currency "STATS", :amount -10, :time 153635268227023, :old 10, :new 0}
  )
