(ns hara.platform.common)

(defn expand-impl
  "expands function, helper for `defimpl`"
  {:added "3.0"}
  [{:keys [protocols suffix prefix]}]
  (let [body (->> protocols
                  (mapcat (fn [sym]
                            (let [{:keys [sigs]} (-> sym resolve deref)
                                  forms (->> sigs
                                             (mapcat (fn [[k {:keys [arglists] :as v}]]
                                                       (map (fn [arglist]
                                                              `(~(:name v) ~arglist
                                                                (~(symbol (str prefix (subs (name k) 1) suffix))
                                                                 ~@arglist)))
                                                            arglists))))]
                              (cons sym forms)))))]
    body))

(defmacro defimpl
  "like gen-class but for records"
  {:added "3.0"}
  [name bindings params & body]
  `(defrecord ~name ~bindings
     ~@(expand-impl params)
     ~@body))

(defmacro extend-impl
  "creates defn from protocols"
  {:added "3.0"}
  [& protocols]
  (let [body (->> protocols
                  (mapcat (fn [[sym {:keys [except]}]]
                            (let [{:keys [sigs]} (-> sym resolve deref)
                                  forms (->> sigs
                                             (filter (fn [[k _]] (not (get except k))))
                                             (map (fn [[k {:keys [arglists] :as v}]]
                                                    (let [fname (symbol (subs (name k) 1))]
                                                      `(defn ~fname ~(first arglists)
                                                         (~(symbol (namespace sym) (name k))
                                                          ~@(first arglists)))))))]
                              forms))))]

    (vec body)))
