(ns hara.net.http.route
  (:require [hara.net.http.handler :as handler]))

(defmulti  -handler-fn
  "extensible method for selecting constructor for handler"
  {:added "3.0"}
  :type)

(defmethod -handler-fn :any       [_] handler/any-handler)
(defmethod -handler-fn :not-found [_] handler/any-handler)
(defmethod -handler-fn :get       [_] handler/method-handler)
(defmethod -handler-fn :post      [_] handler/method-handler)
(defmethod -handler-fn :put       [_] handler/method-handler)
(defmethod -handler-fn :head      [_] handler/method-handler)
(defmethod -handler-fn :patch     [_] handler/method-handler)
(defmethod -handler-fn :delete    [_] handler/method-handler)
(defmethod -handler-fn :resource  [_] handler/resource-handler)
(defmethod -handler-fn :endpoint  [_] handler/endpoint-handler)

(defn single-handler
  "constructs a single method handler
 
   ((single-handler [:get \"/\" (constantly {:status true})])
    {:route \"/\"})
   => {:status true}
 
   (-> ((single-handler [:endpoint \"/\" {:functions {:add (fn [a b] (+ a b))}}])
        {:route \"/\"
         :body (str {:id :add :args [1 2]})})
       :body
       read-string)
   => (contains {:status :return, :data 3, :id :add})"
  {:added "3.0"}
  [x]
  (let [opts-fn  (fn [v]
                   (if (map? v)
                     v
                     {:fn v}))
        m (cond (map? x) x
              
                (vector? x)
                (let [[type & [route opts :as args]] x
                      opts (case (count args)
                             1 (opts-fn route)  
                             2 (-> (opts-fn opts)
                                   (assoc :route route)))]
                  (assoc opts :type type))

                :else
                (throw (ex-info "Not valid." {:input x})))]
    ((-handler-fn m) m)))

(defn handler
  "constructs handler from
 
   ((handler [[:get  \"/hello\" (constantly \"hello\")]
              [:post \"/hello\" (constantly \"hello post\")]])
    {:method :post
     :route \"/hello\"})
   => \"hello\""
  {:added "3.0"}
  [x]
  (if (and (vector? x)
           (or (vector? (first x))
               (map? (first x))))
    (handler/multi-handler (map single-handler x))
    (single-handler x)))
