(ns hara.log.common)

(def ^:dynamic *level* :status)

(def ^:dynamic *context* nil)

(def ^:dynamic *static* false)

(defonce ^:dynamic *logger* nil)

(def +levels+ (merge (zipmap [:debug :status :info :todo :warn :thrown :error :fatal]
                             (range))
                     {:silent -2 :code -1 :note -1 :spy 0 :trace 0 :meter 1}))

(defn set-static!
  "sets the global static variable"
  {:added "3.0"}
  [bool]
  (alter-var-root #'*static* (fn [_] bool)))

(defn set-level!
  "sets the global level variable"
  {:added "3.0"}
  [status]
  (alter-var-root #'*level* (fn [_] status)))

(defn set-context!
  "sets the global level variable"
  {:added "3.0"}
  [context]
  (alter-var-root #'*context* (fn [_] context)))

(defn set-logger!
  "sets the global logger"
  {:added "3.0"}
  [logger]
  (alter-var-root #'*logger* (fn [_] logger)))

(defn put-logger!
  "updates the global logger"
  {:added "3.0"}
  ([{:keys [level context namespace function filter] :as data}]
   (put-logger! *logger* data))
  ([{:keys [instance] :as logger} data]
   (swap! instance merge data)
   logger))
