(ns hara.lib.opencl.image
  (:require [hara.protocol.opencl :as protocol.opencl]
            [hara.function :refer [definvoke]]
            [uncomplicate.clojurecl.core :as cl])
  (:import java.awt.image.DataBuffer
           java.awt.image.BufferedImage))

(definvoke awt-image-create-input
  "creates the buffer for an awt image"
  {:added "3.0"}
  [:method {:multi protocol.opencl/-opencl-create-input
            :val :awt.image}]
  ([{:keys [flags]} img context]
   (let [data-buffer (-> (.getRaster img)
                         (.getDataBuffer))
         data-size (-> (.getDataType data-buffer)
                       (DataBuffer/getDataTypeSize)
                       (/ 8))
         array-size (count (.getData data-buffer))]
     (apply cl/cl-buffer context (* array-size data-size) flags))))

(definvoke awt-image-write-input
  "writes to buffer from awt image"
  {:added "3.0"}
  [:method {:multi protocol.opencl/-opencl-write-input
            :val :awt.image}]
  ([param img buffer queue]
   (cl/enq-write! queue buffer (-> (.getRaster img)
                                   (.getDataBuffer)
                                   (.getData)))))

(definvoke awt-image-read-output
  "reads to awt image from buffer"
  {:added "3.0"}
  [:method {:multi protocol.opencl/-opencl-read-output
            :val :awt.image}]
  ([param img buffer queue]
   (cl/enq-read! queue buffer (-> (.getRaster img)
                                  (.getDataBuffer)
                                  (.getData)))))
