(ns hara.data.pipeline.validate
  (:require [hara.event :as event]
            [hara.function :as fn]))

(defn wrap-single-model-validate
  "validates input according to model
 
  (pipeline/normalise {:account/name \"Chris\"}
                      {:schema (schema/schema examples/account-name-age-sex)
                       :pipeline {:validate {:account {:name number?}}}}
                      *wrappers*)
   => (throws-info {:not-validated true :nsv [:account :name]})
 
   (pipeline/normalise {:account/name \"Bob\"}
                        {:schema (schema/schema examples/account-name-age-sex)
                         :pipeline {:validate {:account {:name #(= % \"Bob\")}}}}
                        *wrappers*)
   => {:account {:name \"Bob\"}}"
  {:added "3.0"}
  [f]
  (fn [subdata [attr] nsv interim fns datasource]
    (let [subvalidate (:validate interim)]
      (cond (fn? subvalidate)
            (let [res (fn/op subvalidate subdata datasource)
                  nsubdata (cond (or (true? res) (nil? res))
                                 subdata

                                 :else
                                 (event/raise [:normalise :not-validated
                                               {:data subdata
                                                :nsv nsv
                                                :key-path (:key-path interim)
                                                :validator subvalidate
                                                :error res}]))]
              (f nsubdata [attr] nsv interim fns datasource))

            :else
            (f subdata [attr] nsv interim fns datasource)))))
