(ns hara.data.pipeline.link)

(defn wrap-link-current
  "adding cleaned up data to table"
  {:added "3.0"}
  ([f]
   (fn [tdata tsch nsv interim fns datasource]
     (let [interim (if (vector? (second (first tsch)))
                     (assoc-in interim [:link :current] tdata)
                     interim)]
       (f tdata tsch nsv interim fns datasource)))))

(defn wrap-link-attr
  "added `:flatten :extra` keys for ref attributes"
  {:added "3.0"}
  ([f]
  (fn [subdata [attr] nsv interim fns datasource]
    (let [interim (cond-> interim 
                    (= (:type attr) :ref) (assoc-in [:link :parent]
                                                    (if (-> attr :cardinality (= :many))
                                                      {(-> attr :ref :rval)
                                                       (keyword (str (name (first nsv)) ".id")
                                                                (:id (-> interim :link :current)))})))]
      (f subdata [attr] nsv interim fns datasource)))))

(defn wrap-link-parent
  ([f]
   (fn [tdata tsch nsv interim fns datasource]
     (let [result (f tdata tsch nsv interim fns datasource)]
       (if (vector? (second (first tsch)))
         (merge (-> interim :link :parent) result)
         result)))))
