(ns hara.data.pipeline.convert
  (:require [hara.function :as fn]))

(defn wrap-single-model-convert
  "converts input according to model
  (pipeline/normalise {:account/name \"Chris\"}
                      {:schema (schema/schema examples/account-name-age-sex)
                       :pipeline {:convert {:account {:name #(.toLowerCase %)}}}}
                      *wrappers*)
   => {:account {:name \"chris\"}}"
  {:added "3.0"}
  [f]
  (fn [subdata [attr] nsv interim fns datasource]
    (let [trans-fn (:convert interim)
          nsubdata (if (fn? trans-fn)
                     (fn/op trans-fn subdata datasource)
                     subdata)]
      (f nsubdata [attr] nsv interim fns datasource))))
