(ns hara.data.pipeline.base.type-check
  (:require [hara.event :as event]
            [hara.data.coerce :as coerce]
            [hara.data.schema.base :as base]))

(defn wrap-single-type-check
  "wraps normalise to type check inputs as well as to coerce incorrect inputs
   (pipeline/normalise {:account {:age \"10\"}}
                        {:schema (schema/schema examples/account-name-age-sex)}
                        {:normalise-single [wrap-single-type-check]})
   => (throws-info {:type :long,
                    :data \"10\",
                    :wrong-type true})
   
   (pipeline/normalise {:account {:age \"10\"}}
                        {:schema (schema/schema examples/account-name-age-sex)
                         :options {:use-coerce true}}
                        {:normalise-single [wrap-single-type-check]})
   => {:account {:age 10}}"
  {:added "3.0"}
  [f]
  (fn [subdata [attr] nsv interim fns datasource]

    (let [t (:type attr)
          chk (base/type-checks (:type datasource) t)]
      (cond
        (or (nil? chk) (chk subdata)) 
        (f subdata [attr] nsv interim fns datasource)

        (-> datasource :options :use-coerce)
        (f (coerce/coerce subdata t) [attr] nsv interim fns datasource)

        :else
        (event/raise [:normalise :wrong-type
                      {:data subdata :nsv nsv :key-path (:key-path interim) :type t}]
                     (str "WRAP_SINGLE_TYPE_CHECK: " subdata " in " nsv " is not of type " t))))))
