(ns hara.data.pipeline.base.ref)

(defn wrap-keyword-id
  "Allow ids to be passed if type is a ref
 
   (-> (pipeline/normalise {:schema (schema/schema {:user {:link [{:type :ref
                                                                   :ref {:ns :user}}]
                                                           :name [{}]}})
                            :process {:input {:user/link 1000}}})
       :process
       :normalised)
   => {:user {:link 1000}}"
  {:added "3.0"}
  [f]
  (fn [subdata [attr] nsv interim fns datasource]
    (if (and (= (:type attr) :ref)
             (keyword? subdata))
      subdata
      (f subdata [attr] nsv interim fns datasource))))
