(ns hara.data.pipeline.base.enum
  (:require [hara.core.base.error :as error]
            [hara.event :as event]
            [hara.string :as string]))

(defn wrap-single-enum
  "wraps normalise with comprehension of the enum type
 
   (pipeline/normalise {:account {:type :account.type/guest}}
                        {:schema (schema/schema {:account/type [{:type :enum
                                                                 :enum {:ns :account.type
                                                                        :values #{:vip :guest}}}]})}
                        {:normalise-single [wrap-single-enum]})
   => {:account {:type :guest}}
   "
  {:added "3.0"}
  [f]
  (fn [subdata [attr] nsv interim fns datasource]
    (cond (= :enum (:type attr))
          (let [kns (-> attr :enum :ns)
                v (if (and kns (= (string/path-ns subdata) kns))
                    (string/path-stem subdata)
                    subdata)
                chk (-> attr :enum :values)]
            (if-not (error/suppress (chk v))
              (event/raise [:normalise :wrong-input
                            {:data subdata :nsv nsv :key-path (:key-path interim) :check chk}]
                           (str "WRAP_SINGLE_ENUMS: " v " in " nsv " can only be one of: " chk))
              (f v [attr] nsv interim fns datasource)))
          :else
          (f subdata [attr] nsv interim fns datasource))))
